/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;
import vazkii.ambience.network.AmbiencePackageHandler;
import vazkii.ambience.network.MyMessage;

public class CreateAreaCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_AREA = (source, builder) -> {
        ArrayList<String> AreasNames = new ArrayList<String>();
        for (Area entry : Ambience.getWorldData().listAreas) {
            if (entry.getName().contains(".")) continue;
            AreasNames.add(entry.getName());
        }
        return ISuggestionProvider.func_197005_b(AreasNames, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"area");
        root.then(Commands.func_197057_a((String)"help").executes(source -> CreateAreaCommand.helpArea((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h())));
        root.then(Commands.func_197057_a((String)"list").executes(source -> CreateAreaCommand.listArea((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h())));
        root.then(Commands.func_197057_a((String)"showInfo").executes(source -> CreateAreaCommand.showInfoArea((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h())));
        root.then(Commands.func_197056_a((String)"areaName", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREA).then(Commands.func_197056_a((String)"position1", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"position2", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"playInstant", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"playAtNight", (ArgumentType)BoolArgumentType.bool()).executes(source -> CreateAreaCommand.createArea((CommandSource)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"areaName"), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position1"), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position2"), BoolArgumentType.getBool((CommandContext)source, (String)"playInstant"), BoolArgumentType.getBool((CommandContext)source, (String)"playAtNight"))))))));
        dispatcher.register(root);
    }

    public static int createArea(CommandSource source, String areaName, PlayerEntity player, BlockPos pos1, BlockPos pos2, Boolean playInstant, Boolean playAtNight) {
        if (pos1.equals((Object)pos2)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "The coordinates can't be the same"), true);
            return 0;
        }
        Area currentArea = new Area();
        currentArea.setOperation(Area.Operation.CREATE);
        currentArea.setName(areaName);
        currentArea.setPlayAtNight(playAtNight);
        currentArea.setInstantPlay(playInstant);
        currentArea.setID(Ambience.getWorldData().listAreas.size());
        currentArea.setDimension(player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a());
        currentArea.setPos1(new Vector3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p()));
        currentArea.setPos2(new Vector3d((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p()));
        Ambience.sync = true;
        WorldData data = new WorldData().GetArasforWorld((ServerWorld)player.field_70170_p);
        CompoundNBT updatedAreas = null;
        data.addArea(currentArea);
        updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
        AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
        data.saveData();
        Ambience.getWorldData().listAreas = data.listAreas;
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Region created with success!"), true);
        return 1;
    }

    public static int helpArea(CommandSource source, PlayerEntity player) {
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "<--- Area Commands --->"), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "/area -> creates a new region."), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "/area list -> show the information for all the regions created."), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "/area showInfo -> show the region informations for the current player standing region."), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "/areadel -> delete a region"), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "/areaedit -> edit a region"), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "<--------------------->"), true);
        return 1;
    }

    public static int listArea(CommandSource source, PlayerEntity player) {
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "<-------------------------------->"), true);
        for (Area area : Ambience.getWorldData().listAreas) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Name: " + area.getName() + " ID: " + area.getID() + " P1:" + area.getPos1() + " P2:" + area.getPos2()), true);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "<-------------------------------->"), true);
        return 1;
    }

    public static int showInfoArea(CommandSource source, PlayerEntity player) {
        Area area = Area.getBlockStandingArea(player.func_233580_cy_());
        if (area != null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "<-------------------------------->"), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "ID: " + area.getID()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Name: " + area.getName()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Pos1: " + area.getPos1()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Pos2: " + area.getPos2()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Dimension: " + area.getDimension()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Instant Play: " + area.isInstantPlay()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Play at night: " + area.isPlayatNight()), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "<-------------------------------->"), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Must be inside a Region to show the informations"), true);
        }
        return 1;
    }
}

