/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.blocks;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import vazkii.ambience.Util.RegistryHandler;
import vazkii.ambience.World.Biomes.Area;
import vazkii.ambience.network.AmbiencePackageHandler;
import vazkii.ambience.network.MyMessage;

public class SongSwitcher
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final IntegerProperty DIRECTION = IntegerProperty.func_177719_a((String)"direction", (int)0, (int)3);
    public static final VoxelShape SHAPE_S = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)1.7763568394002505E-15, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape SHAPE_N = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)1.7763568394002505E-15, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape SHAPE_E = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)1.7763568394002505E-15, (double)2.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape SHAPE_W = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)12.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)0.0, (double)1.7763568394002505E-15, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape SHAPE_U = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)1.7763568394002505E-15, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape SHAPE_D = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)1.7763568394002505E-15, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static Material material = Material.field_151575_d;
    public static SoundType soundType = SoundType.field_185848_a;

    public SongSwitcher(String color) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(2.0f, 5.0f).func_200947_a(soundType).harvestLevel(1).harvestTool(ToolType.PICKAXE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case EAST: {
                return SHAPE_E;
            }
            case WEST: {
                return SHAPE_W;
            }
            case UP: {
                return SHAPE_U;
            }
            case DOWN: {
                return SHAPE_D;
            }
        }
        return SHAPE_N;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.4f;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"songswitcher.Desc", (Object[])new Object[0])));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)))).func_206870_a((Property)DIRECTION, state.func_177229_b((Property)DIRECTION));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING))).func_206870_a((Property)DIRECTION, state.func_177229_b((Property)DIRECTION));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{DIRECTION});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)DIRECTION, (Comparable)Integer.valueOf(0));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        Area currentArea = Area.getBlockStandingArea(pos);
        if (worldIn instanceof ServerWorld && currentArea != null) {
            currentArea.setRedstoneStrength(this.getRedstonePowerFromNeighbors(fromPos, worldIn));
            currentArea.setOperation(Area.Operation.EDIT);
            AmbiencePackageHandler.sendToAll(new MyMessage(currentArea.SerializeThis()));
            if (this.getRedstonePowerFromNeighbors(fromPos, worldIn) != 0) {
                this.setState(true, worldIn, pos, state);
            } else {
                this.setState(false, worldIn, pos, state);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        Area currentArea = Area.getBlockStandingArea(pos);
        int dir = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        worldIn.func_180501_a(pos, (BlockState)((BlockState)((Block)RegistryHandler.SongSwitcher.get()).func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)DIRECTION, (Comparable)Integer.valueOf(dir)), 2);
        if (!(worldIn.func_217369_A().get(0) instanceof ServerPlayerEntity) && currentArea != null) {
            int power = 0;
            power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), worldIn);
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), worldIn);
            }
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), worldIn);
            }
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1), worldIn);
            }
            currentArea.setRedstoneStrength(power);
            currentArea.setOperation(Area.Operation.EDIT);
            AmbiencePackageHandler.sendToServer(new MyMessage(currentArea.SerializeThis()));
            if (power != 0) {
                this.setState(true, worldIn, pos, state);
            } else {
                this.setState(false, worldIn, pos, state);
            }
        }
    }

    public int getRedstonePowerFromNeighbors(BlockPos pos, World worldIn) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            if (direction.name() == "") continue;
            int j = worldIn.func_175651_c(pos, direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public void setState(boolean active, World worldIn, BlockPos pos, BlockState state) {
        if (active) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)((Block)RegistryHandler.SongSwitcher_lit.get()).func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)DIRECTION, state.func_177229_b((Property)DIRECTION)), 2);
        } else {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)((Block)RegistryHandler.SongSwitcher.get()).func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)DIRECTION, state.func_177229_b((Property)DIRECTION)), 2);
        }
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        Area currentArea;
        PlayerEntity player = worldIn.func_217366_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        if (!(player instanceof ServerPlayerEntity) && (currentArea = Area.getBlockStandingArea(pos)) != null) {
            currentArea.setRedstoneStrength(0);
            currentArea.setOperation(Area.Operation.EDIT);
            AmbiencePackageHandler.sendToServer(new MyMessage(currentArea.SerializeThis()));
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (worldIn instanceof ServerWorld) {
            PlayerEntity player = worldIn.func_217366_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
            Area currentArea = Area.getBlockStandingArea(pos);
            currentArea.setRedstoneStrength(0);
            currentArea.setOperation(Area.Operation.EDIT);
            AmbiencePackageHandler.sendToServer(new MyMessage(currentArea.SerializeThis()));
            super.func_180652_a(worldIn, pos, explosionIn);
        }
    }
}

