/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.World.Biomes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.Border;

public class Area
implements Comparator<Area> {
    private Operation operation;
    private String Dimension = "";
    private int ID;
    private int redstoneStrength;
    private String name;
    private boolean instantPlay = false;
    private boolean playAtNight = false;
    private int cubicArea = 0;
    private String SelectedBlock = "";
    private Vector3d pos1;
    private Vector3d pos2;

    public boolean isPlayatNight() {
        return this.playAtNight;
    }

    public boolean isInstantPlay() {
        return this.instantPlay;
    }

    public void setPlayAtNight(boolean playAtNight) {
        this.playAtNight = playAtNight;
    }

    public void setInstantPlay(boolean instantPlay) {
        this.instantPlay = instantPlay;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getDimension() {
        return this.Dimension;
    }

    public void setDimension(String dimension) {
        this.Dimension = dimension;
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    public void setRedstoneStrength(int Strength) {
        this.redstoneStrength = Strength;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int iD) {
        this.ID = iD;
    }

    public Area() {
    }

    public Area(String parName) {
        this.name = parName;
    }

    public String getName() {
        return this.name;
    }

    public String getSelectedBlock() {
        return this.SelectedBlock;
    }

    public String setSelectedBlock(String selectedBlock) {
        this.SelectedBlock = selectedBlock;
        return this.SelectedBlock;
    }

    public Vector3d getPos1() {
        return this.pos1;
    }

    public void setPos1(Vector3d pos1) {
        this.pos1 = pos1;
    }

    public Vector3d getPos2() {
        return this.pos2;
    }

    public void setPos2(Vector3d pos2) {
        this.pos2 = pos2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void resetSelection() {
        this.pos1 = null;
        this.pos2 = null;
    }

    public String simplifyOperation() {
        switch (this.getOperation()) {
            case CREATE: {
                return "c";
            }
            case EDIT: {
                return "e";
            }
            case DELETE: {
                return "d";
            }
            case SELECT: {
                return "s";
            }
            case OPENEDIT: {
                return "oe";
            }
        }
        return "c";
    }

    public CompoundNBT getPosListTag() {
        CompoundNBT posCompound = new CompoundNBT();
        if (this.pos1 != null) {
            posCompound.func_74780_a("x1", this.pos1.field_72450_a);
            posCompound.func_74780_a("y1", this.pos1.field_72448_b);
            posCompound.func_74780_a("z1", this.pos1.field_72449_c);
        }
        if (this.pos2 != null) {
            posCompound.func_74780_a("x2", this.pos2.field_72450_a);
            posCompound.func_74780_a("y2", this.pos2.field_72448_b);
            posCompound.func_74780_a("z2", this.pos2.field_72449_c);
        }
        return posCompound;
    }

    private int generateNewID() {
        int newid = 0;
        ArrayList<String> idsList = new ArrayList<String>();
        Iterator<Area> iterator = Ambience.getWorldData().listAreas.iterator();
        while (iterator.hasNext()) {
            idsList.add(Integer.toString(iterator.next().ID));
        }
        for (int i = 0; i <= idsList.size(); ++i) {
            if (idsList.contains(Integer.toString(i))) continue;
            newid = i;
            break;
        }
        return newid;
    }

    public static Area getPlayerStandingArea(PlayerEntity player) {
        ArrayList<Area> Areas = new ArrayList<Area>();
        if (Ambience.getWorldData().listAreas != null) {
            for (Area area : Ambience.getWorldData().listAreas) {
                if (!area.getDimension().equals(player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a())) continue;
                Border border = new Border(area.getPos1(), area.getPos2());
                if (!(border.p1 != null & border.p2 != null) || !border.contains(player.func_213303_ch())) continue;
                area.getCubicArea();
                Areas.add(area);
            }
        }
        Ambience.multiArea = Areas.size();
        if (Areas.size() > 0) {
            Area minArea = Collections.min(Areas, new Area());
            return minArea;
        }
        return null;
    }

    public static Area getBlockStandingArea(BlockPos pos) {
        ArrayList<Area> Areas = new ArrayList<Area>();
        if (Ambience.getWorldData().listAreas != null) {
            for (Area area : Ambience.getWorldData().listAreas) {
                Border border = new Border(area.getPos1(), area.getPos2());
                if (!(border.p1 != null & border.p2 != null) || !border.contains(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
                Areas.add(area);
            }
        }
        if (Areas.size() > 0) {
            Area minArea = Collections.min(Areas, new Area());
            return minArea;
        }
        return null;
    }

    public static Area getAreabyID(int id) {
        for (Area area : Ambience.getWorldData().listAreas) {
            if (area.ID != id) continue;
            return area;
        }
        return null;
    }

    @Override
    public int compare(Area a, Area b) {
        if (a.cubicArea < b.cubicArea) {
            return -1;
        }
        if (a.cubicArea == b.cubicArea) {
            return 0;
        }
        return 1;
    }

    public void getCubicArea() {
        double lenght = Math.abs(this.pos1.field_72450_a - this.pos2.field_72450_a) + 1.0;
        double width = Math.abs(this.pos1.field_72449_c - this.pos2.field_72449_c) + 1.0;
        double height = Math.abs(this.pos1.field_72448_b - this.pos2.field_72448_b - 1.0);
        this.cubicArea = (int)(lenght * width * height);
    }

    public CompoundNBT SerializeThis() {
        if (this.getOperation() == Operation.CREATE) {
            this.setID(this.generateNewID());
        }
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_218657_a("Pos", (INBT)this.getPosListTag());
        tagCompound.func_74778_a("Name", this.getName());
        tagCompound.func_74778_a("D", this.getDimension());
        tagCompound.func_74768_a("ID", this.getID());
        tagCompound.func_74778_a("op", this.simplifyOperation());
        tagCompound.func_74757_a("playNight", this.isPlayatNight());
        tagCompound.func_74757_a("instP", this.isInstantPlay());
        tagCompound.func_74778_a("SelectedBlock", this.SelectedBlock);
        tagCompound.func_74768_a("RedstoneStrength", this.getRedstoneStrength());
        return tagCompound;
    }

    public static Area DeSerialize(CompoundNBT nbt) {
        Area area = new Area(nbt.func_74779_i("Name"));
        area.setDimension(nbt.func_74779_i("D"));
        area.setID(nbt.func_74762_e("ID"));
        area.setPlayAtNight(nbt.func_74767_n("playNight"));
        area.setInstantPlay(nbt.func_74767_n("instP"));
        area.setSelectedBlock(nbt.func_74779_i("SelectedBlock"));
        area.setRedstoneStrength(nbt.func_74762_e("RedstoneStrength"));
        switch (nbt.func_74779_i("op")) {
            case "c": {
                area.setOperation(Operation.CREATE);
                break;
            }
            case "e": {
                area.setOperation(Operation.EDIT);
                break;
            }
            case "d": {
                area.setOperation(Operation.DELETE);
                break;
            }
            case "s": {
                area.setOperation(Operation.SELECT);
                break;
            }
            case "oe": {
                area.setOperation(Operation.OPENEDIT);
                break;
            }
            default: {
                area.setOperation(Operation.CREATE);
            }
        }
        CompoundNBT tagListPos = nbt.func_74775_l("Pos");
        Vector3d pos1 = new Vector3d(tagListPos.func_74769_h("x1"), tagListPos.func_74769_h("y1"), tagListPos.func_74769_h("z1"));
        Vector3d pos2 = new Vector3d(tagListPos.func_74769_h("x2"), tagListPos.func_74769_h("y2"), tagListPos.func_74769_h("z2"));
        if (pos1.func_82615_a() != 0.0 & pos1.func_82617_b() != 0.0 & pos1.func_82616_c() != 0.0) {
            area.setPos1(pos1);
        }
        if (pos2.func_82615_a() != 0.0 & pos2.func_82617_b() != 0.0 & pos2.func_82616_c() != 0.0) {
            area.setPos2(pos2);
        }
        return area;
    }

    public static List<Area> DeSerializeList(CompoundNBT nbt) {
        ArrayList<Area> localListAreas = new ArrayList<Area>();
        for (int i = 0; i < nbt.func_74762_e("lenght"); ++i) {
            CompoundNBT areaCompound = (CompoundNBT)nbt.func_74781_a("Area" + i);
            Area area = new Area(areaCompound.func_74779_i("Name"));
            area.setDimension(areaCompound.func_74779_i("D"));
            area.setID(areaCompound.func_74762_e("ID"));
            area.setPlayAtNight(areaCompound.func_74767_n("playNight"));
            area.setInstantPlay(areaCompound.func_74767_n("instP"));
            area.setRedstoneStrength(areaCompound.func_74762_e("RedstoneStrength"));
            CompoundNBT tagListPos = areaCompound.func_74775_l("Pos");
            Vector3d pos1 = new Vector3d(tagListPos.func_74769_h("x1"), tagListPos.func_74769_h("y1"), tagListPos.func_74769_h("z1"));
            area.setPos1(pos1);
            Vector3d pos2 = new Vector3d(tagListPos.func_74769_h("x2"), tagListPos.func_74769_h("y2"), tagListPos.func_74769_h("z2"));
            area.setPos1(pos1);
            area.setPos2(pos2);
            localListAreas.add(area);
        }
        return localListAreas;
    }

    public static enum Operation {
        CREATE,
        EDIT,
        DELETE,
        SELECT,
        OPENEDIT;

    }
}

