/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.BadChunkSummary;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.iff.PaddingChunkSummary;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import org.jaudiotagger.audio.wav.chunk.WavId3Chunk;
import org.jaudiotagger.audio.wav.chunk.WavListChunk;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");
    private String loggingName;

    public WavTagReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public WavTag read(Path path) throws CannotReadException, IOException {
        WavTag tag;
        block14: {
            logger.config(this.loggingName + " Read Tag:start");
            tag = new WavTag(TagOptionSingleton.getInstance().getWavOptions());
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, tag)) continue;
                        break block14;
                    }
                    break block14;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        this.createDefaultMetadataTagsIfMissing(tag);
        logger.config(this.loggingName + " Read Tag:end");
        return tag;
    }

    private void createDefaultMetadataTagsIfMissing(WavTag tag) {
        if (!tag.isExistingId3Tag()) {
            tag.setID3Tag(WavTag.createDefaultID3Tag());
        }
        if (!tag.isExistingInfoTag()) {
            tag.setInfoTag(new WavInfoTag());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean readChunk(FileChannel fc, WavTag tag) throws IOException, CannotReadException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        String id = chunkHeader.getID();
        logger.config(this.loggingName + " Reading Chunk:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
        WavChunkType chunkType = WavChunkType.get(id);
        if (chunkType != null) {
            switch (chunkType) {
                case LIST: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getInfoTag() == null) {
                        WavListChunk chunk = new WavListChunk(this.loggingName, Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag);
                        if (((Chunk)chunk).readChunk()) break;
                        logger.severe(this.loggingName + " LIST readChunkFailed");
                        return false;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    logger.warning(this.loggingName + " Ignoring LIST chunk because already have one:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile() - 1L) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    break;
                }
                case ID3_UPPERCASE: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getID3Tag() == null) {
                        WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag, this.loggingName);
                        if (!((Chunk)chunk).readChunk()) {
                            logger.severe(this.loggingName + " ID3 readChunkFailed");
                            return false;
                        }
                        logger.severe(this.loggingName + " ID3 chunk should be id3:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                        break;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    logger.warning(this.loggingName + " Ignoring id3 chunk because already have one:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    break;
                }
                case ID3: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getID3Tag() == null) {
                        WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag, this.loggingName);
                        if (((Chunk)chunk).readChunk()) break;
                        logger.severe(this.loggingName + " id3 readChunkFailed");
                        return false;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    logger.warning(this.loggingName + " Ignoring id3 chunk because already have one:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    break;
                }
                case CORRUPT_ID3_EARLY: {
                    logger.severe(this.loggingName + " Found Corrupt id3 chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                    if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                        tag.setIncorrectlyAlignedTag(true);
                    }
                    fc.position(fc.position() - 7L);
                    return true;
                }
                case CORRUPT_ID3_LATE: {
                    logger.severe(this.loggingName + " Found Corrupt id3 chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                    if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                        tag.setIncorrectlyAlignedTag(true);
                    }
                    fc.position(fc.position() - 7L);
                    return true;
                }
                default: {
                    tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
            }
        } else {
            if (id.substring(1, 4).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk (2), starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (id.equals("\u0000\u0000\u0000\u0000") && chunkHeader.getSize() == 0L) {
                int fileRemainder = (int)(fc.size() - fc.position());
                ByteBuffer restOfFile = ByteBuffer.allocate(fileRemainder);
                int result = fc.read(restOfFile);
                restOfFile.flip();
                while (restOfFile.get() == 0) {
                }
                logger.severe(this.loggingName + "Found Null Padding, starting at " + chunkHeader.getStartLocationInFile() + ", size:" + restOfFile.position() + 8);
                fc.position(chunkHeader.getStartLocationInFile() + (long)restOfFile.position() + 8L - 1L);
                tag.addChunkSummary(new PaddingChunkSummary(chunkHeader.getStartLocationInFile(), restOfFile.position() - 1));
                tag.setNonStandardPadding(true);
                return true;
            }
            if (chunkHeader.getSize() < 0L) {
                logger.severe(this.loggingName + " Size of Chunk Header is negative, skipping to file end:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                tag.addChunkSummary(new BadChunkSummary(chunkHeader.getStartLocationInFile(), fc.size() - fc.position()));
                tag.setBadChunkData(true);
                fc.position(fc.size());
            } else if (fc.position() + chunkHeader.getSize() <= fc.size()) {
                logger.severe(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize() + " for " + chunkHeader.getID());
                tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                fc.position(fc.position() + chunkHeader.getSize());
            } else {
                logger.severe(this.loggingName + " Size of Chunk Header larger than data, skipping to file end:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                tag.addChunkSummary(new BadChunkSummary(chunkHeader.getStartLocationInFile(), fc.size() - fc.position()));
                tag.setBadChunkData(true);
                fc.position(fc.size());
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

