/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.util.HashMap;
import java.util.Map;

public enum WavSubFormat {
    FORMAT_PCM(1, "WAV PCM"),
    FORMAT_FLOAT(3, "WAV IEEE_FLOAT"),
    FORMAT_ALAW(6, "WAV A-LAW"),
    FORMAT_MULAW(7, "WAV \u00c2\u00b5-LAW"),
    FORMAT_EXTENSIBLE(65534, "EXTENSIBLE"),
    FORMAT_GSM_COMPRESSED(49, "GSM_COMPRESSED");

    private int code;
    private String description;
    private static final Map<Integer, WavSubFormat> lookup;

    private WavSubFormat(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static WavSubFormat getByCode(Integer code) {
        return lookup.get(code);
    }

    static {
        lookup = new HashMap<Integer, WavSubFormat>();
        for (WavSubFormat next : WavSubFormat.values()) {
            lookup.put(next.getCode(), next);
        }
    }
}

