/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4HdlrBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;
import org.jaudiotagger.utils.ShiftData;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;

public class Mp4TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    private Mp4TagCreator tc = new Mp4TagCreator();
    private String loggingName;

    public Mp4TagWriter(String loggingName) {
        this.loggingName = loggingName;
    }

    private void writeMetadataSameSize(SeekableByteChannel fc, Mp4BoxHeader ilstHeader, ByteBuffer newIlstData) throws IOException {
        logger.config("Writing:Option 1:Same Size");
        fc.position(ilstHeader.getFilePos());
        fc.write(newIlstData);
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
        if (udtaHeader != null) {
            udtaHeader.setLength(udtaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(udtaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(udtaHeader.getHeaderData());
        }
        if (metaHeader != null) {
            metaHeader.setLength(metaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(metaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(metaHeader.getHeaderData());
        }
    }

    private void writeOldMetadataLargerThanNewMetadata(SeekableByteChannel fc, Mp4BoxHeader moovHeader, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader, Mp4BoxHeader ilstHeader, Mp4BoxHeader mdatHeader, Mp4BoxHeader neroTagsHeader, ByteBuffer moovBuffer, ByteBuffer newIlstData, List<Mp4StcoBox> stcos, int sizeOfExistingMetaLevelFreeAtom) throws IOException {
        logger.config("Writing:Option 1:Smaller Size");
        int ilstPositionRelativeToAfterMoovHeader = (int)(ilstHeader.getFilePos() - (moovHeader.getFilePos() + 8L));
        int sizeOfNewIlstAtom = newIlstData.limit();
        if (sizeOfExistingMetaLevelFreeAtom > 0) {
            logger.config("Writing:Option 2:Smaller Size have free atom:" + ilstHeader.getLength() + ":" + sizeOfNewIlstAtom);
            fc.position(ilstHeader.getFilePos());
            fc.write(newIlstData);
            int newFreeSize = sizeOfExistingMetaLevelFreeAtom + (ilstHeader.getLength() - sizeOfNewIlstAtom);
            Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
            fc.write(newFreeBox.getHeader().getHeaderData());
            fc.write(newFreeBox.getData());
        } else {
            int newFreeSize = ilstHeader.getLength() - sizeOfNewIlstAtom - 8;
            if (newFreeSize > 0) {
                logger.config("Writing:Option 3:Smaller Size can create free atom");
                fc.position(ilstHeader.getFilePos());
                fc.write(newIlstData);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize);
                fc.write(newFreeBox.getHeader().getHeaderData());
                fc.write(newFreeBox.getData());
            } else {
                logger.config("Writing:Option 4:Smaller Size <=8 cannot create free atoms");
                long endOfOriginalMoovAtom = moovHeader.getFileEndPos();
                int sizeReducedBy = ilstHeader.getLength() - sizeOfNewIlstAtom;
                if (mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                    for (Mp4StcoBox stoc : stcos) {
                        stoc.adjustOffsets(-sizeReducedBy);
                    }
                }
                this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, -sizeReducedBy, udtaHeader, metaHeader);
                fc.position(moovHeader.getFilePos());
                fc.write(moovHeader.getHeaderData());
                moovBuffer.rewind();
                moovBuffer.limit(ilstPositionRelativeToAfterMoovHeader);
                fc.write(moovBuffer);
                fc.write(newIlstData);
                moovBuffer.limit(moovBuffer.capacity());
                moovBuffer.position(ilstPositionRelativeToAfterMoovHeader + ilstHeader.getLength());
                fc.write(moovBuffer);
                this.shiftData(fc, endOfOriginalMoovAtom, Math.abs(sizeReducedBy));
            }
        }
    }

    private void shiftData(SeekableByteChannel fc, long startDeleteFrom, int deleteSize) throws IOException {
        fc.position(startDeleteFrom);
        ByteBuffer buffer = ByteBuffer.allocate((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (fc.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = fc.position();
            fc.position(readPosition - (long)deleteSize - (long)buffer.limit());
            fc.write(buffer);
            fc.position(readPosition);
            buffer.compact();
        }
        long newLength = fc.size() - (long)deleteSize;
        logger.config(this.loggingName + "-------------Setting new length to:" + newLength);
        fc.truncate(newLength);
    }

    private void writeNewMetadataLargerButCanUseFreeAtom(SeekableByteChannel fc, Mp4BoxHeader ilstHeader, int sizeOfExistingMetaLevelFreeAtom, ByteBuffer newIlstData, int additionalSpaceRequiredForMetadata) throws IOException, CannotWriteException {
        int newFreeSize = sizeOfExistingMetaLevelFreeAtom - additionalSpaceRequiredForMetadata;
        logger.config("Writing:Option 5;Larger Size can use meta free atom need extra:" + newFreeSize + "bytes");
        fc.position(ilstHeader.getFilePos());
        fc.write(newIlstData);
        Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
        fc.write(newFreeBox.getHeader().getHeaderData());
        fc.write(newFreeBox.getData());
    }

    public void write(Tag tag, Path file) throws CannotWriteException {
        logger.config("Started writing tag data");
        try (SeekableByteChannel fc = Files.newByteChannel(file, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            int positionOfNewIlstAtomRelativeToMoovAtom;
            int positionOfStartOfIlstAtomInMoovBuffer;
            Mp4AtomTree atomTree;
            int sizeOfExistingIlstAtom = 0;
            long endOfMoov = 0L;
            try {
                atomTree = new Mp4AtomTree(fc, false);
            }
            catch (CannotReadException cre) {
                throw new CannotWriteException(cre.getMessage());
            }
            Mp4BoxHeader mdatHeader = atomTree.getBoxHeader(atomTree.getMdatNode());
            if (mdatHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_CANNOT_FIND_AUDIO.getMsg());
            }
            ByteBuffer newIlstData = this.tc.convertMetadata(tag);
            newIlstData.rewind();
            int sizeRequiredByNewIlstAtom = newIlstData.limit();
            Mp4BoxHeader moovHeader = atomTree.getBoxHeader(atomTree.getMoovNode());
            List<Mp4StcoBox> stcos = atomTree.getStcos();
            Mp4BoxHeader ilstHeader = atomTree.getBoxHeader(atomTree.getIlstNode());
            Mp4BoxHeader udtaHeader = atomTree.getBoxHeader(atomTree.getUdtaNode());
            Mp4BoxHeader metaHeader = atomTree.getBoxHeader(atomTree.getMetaNode());
            Mp4BoxHeader hdlrMetaHeader = atomTree.getBoxHeader(atomTree.getHdlrWithinMetaNode());
            Mp4BoxHeader neroTagsHeader = atomTree.getBoxHeader(atomTree.getTagsNode());
            Mp4BoxHeader trakHeader = atomTree.getBoxHeader(atomTree.getTrakNodes().get(atomTree.getTrakNodes().size() - 1));
            ByteBuffer moovBuffer = atomTree.getMoovBuffer();
            if (udtaHeader != null) {
                if (metaHeader != null) {
                    if (ilstHeader != null) {
                        sizeOfExistingIlstAtom = ilstHeader.getLength();
                        positionOfStartOfIlstAtomInMoovBuffer = (int)ilstHeader.getFilePos();
                        positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionOfStartOfIlstAtomInMoovBuffer - (moovHeader.getFilePos() + 8L));
                    } else if (hdlrMetaHeader != null) {
                        positionOfStartOfIlstAtomInMoovBuffer = (int)hdlrMetaHeader.getFileEndPos();
                        positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionOfStartOfIlstAtomInMoovBuffer - (moovHeader.getFilePos() + 8L));
                    } else {
                        positionOfStartOfIlstAtomInMoovBuffer = (int)metaHeader.getFilePos() + 8 + 4;
                        positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionOfStartOfIlstAtomInMoovBuffer - (moovHeader.getFilePos() + 8L));
                    }
                } else {
                    positionOfNewIlstAtomRelativeToMoovAtom = moovHeader.getLength() - 8;
                    positionOfStartOfIlstAtomInMoovBuffer = (int)moovHeader.getFileEndPos();
                }
            } else if (metaHeader != null) {
                positionOfStartOfIlstAtomInMoovBuffer = (int)trakHeader.getFileEndPos();
                positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionOfStartOfIlstAtomInMoovBuffer - (moovHeader.getFilePos() + 8L));
            } else {
                positionOfStartOfIlstAtomInMoovBuffer = (int)moovHeader.getFileEndPos();
                positionOfNewIlstAtomRelativeToMoovAtom = moovHeader.getLength() - 8;
            }
            int sizeOfExistingMetaLevelFreeAtom = this.getMetaLevelFreeAtomSize(atomTree);
            int positionOfTopLevelFreeAtom = 0;
            int sizeOfExistingTopLevelFreeAtom = 0;
            boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = true;
            for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
                if (!parentNode.isRoot()) continue;
                Mp4BoxHeader topLevelFreeHeader = (Mp4BoxHeader)freeNode.getUserObject();
                sizeOfExistingTopLevelFreeAtom = topLevelFreeHeader.getLength();
                positionOfTopLevelFreeAtom = (int)topLevelFreeHeader.getFilePos();
                break;
            }
            if (sizeOfExistingTopLevelFreeAtom > 0) {
                if ((long)positionOfTopLevelFreeAtom > mdatHeader.getFilePos()) {
                    topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
                } else if ((long)positionOfTopLevelFreeAtom < moovHeader.getFilePos()) {
                    topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
                }
            } else {
                positionOfTopLevelFreeAtom = (int)mdatHeader.getFilePos();
            }
            logger.config("Read header successfully ready for writing");
            if (sizeOfExistingIlstAtom == sizeRequiredByNewIlstAtom) {
                this.writeMetadataSameSize(fc, ilstHeader, newIlstData);
            } else if (sizeOfExistingIlstAtom > sizeRequiredByNewIlstAtom) {
                this.writeOldMetadataLargerThanNewMetadata(fc, moovHeader, udtaHeader, metaHeader, ilstHeader, mdatHeader, neroTagsHeader, moovBuffer, newIlstData, stcos, sizeOfExistingMetaLevelFreeAtom);
            } else {
                int additionalSpaceRequiredForMetadata = sizeRequiredByNewIlstAtom - sizeOfExistingIlstAtom;
                if (additionalSpaceRequiredForMetadata <= sizeOfExistingMetaLevelFreeAtom - 8) {
                    this.writeNewMetadataLargerButCanUseFreeAtom(fc, ilstHeader, sizeOfExistingMetaLevelFreeAtom, newIlstData, additionalSpaceRequiredForMetadata);
                } else {
                    int additionalMetaSizeThatWontFitWithinMetaAtom = additionalSpaceRequiredForMetadata - sizeOfExistingMetaLevelFreeAtom;
                    fc.position(moovHeader.getFilePos());
                    if (udtaHeader == null) {
                        this.writeNoExistingUdtaAtom(fc, newIlstData, moovHeader, moovBuffer, mdatHeader, stcos, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, neroTagsHeader);
                    } else if (metaHeader == null) {
                        this.writeNoExistingMetaAtom(udtaHeader, fc, newIlstData, moovHeader, moovBuffer, mdatHeader, stcos, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, neroTagsHeader, positionOfStartOfIlstAtomInMoovBuffer, sizeOfExistingIlstAtom, positionOfTopLevelFreeAtom, additionalMetaSizeThatWontFitWithinMetaAtom);
                    } else {
                        this.writeHaveExistingMetadata(udtaHeader, metaHeader, fc, positionOfNewIlstAtomRelativeToMoovAtom, moovHeader, moovBuffer, mdatHeader, stcos, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, newIlstData, neroTagsHeader, sizeOfExistingIlstAtom);
                    }
                }
            }
            this.checkFileWrittenCorrectly(mdatHeader, fc, stcos);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void convertandWriteTagsAtomToFreeAtom(SeekableByteChannel fc, Mp4BoxHeader tagsHeader) throws IOException {
        Mp4FreeBox freeBox = new Mp4FreeBox(tagsHeader.getDataLength());
        fc.write(freeBox.getHeader().getHeaderData());
        fc.write(freeBox.getData());
    }

    private int getMetaLevelFreeAtomSize(Mp4AtomTree atomTree) {
        int oldMetaLevelFreeAtomSize = 0;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            DefaultMutableTreeNode brotherNode = freeNode.getPreviousSibling();
            if (parentNode.isRoot()) continue;
            Mp4BoxHeader parentHeader = (Mp4BoxHeader)parentNode.getUserObject();
            Mp4BoxHeader freeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            if (brotherNode == null) continue;
            Mp4BoxHeader brotherHeader = (Mp4BoxHeader)brotherNode.getUserObject();
            if (!parentHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || !brotherHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) continue;
            oldMetaLevelFreeAtomSize = freeHeader.getLength();
            break;
        }
        return oldMetaLevelFreeAtomSize;
    }

    private void checkFileWrittenCorrectly(Mp4BoxHeader mdatHeader, SeekableByteChannel fc, List<Mp4StcoBox> stcos) throws CannotWriteException, IOException {
        logger.config("Checking file has been written correctly");
        try {
            Mp4AtomTree newAtomTree = new Mp4AtomTree(fc, false);
            Mp4BoxHeader newMdatHeader = newAtomTree.getBoxHeader(newAtomTree.getMdatNode());
            if (newMdatHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_DATA.getMsg());
            }
            if (newMdatHeader.getLength() != mdatHeader.getLength()) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_DATA_CORRUPT.getMsg());
            }
            Mp4BoxHeader newUdtaHeader = newAtomTree.getBoxHeader(newAtomTree.getUdtaNode());
            if (newUdtaHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            Mp4BoxHeader newMetaHeader = newAtomTree.getBoxHeader(newAtomTree.getMetaNode());
            if (newMetaHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            List<Mp4StcoBox> newStcos = newAtomTree.getStcos();
            if (newStcos.size() != stcos.size()) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_NUMBER_OF_TRACKS.getMsg(stcos.size(), newStcos.size()));
            }
            int shift = 0;
            for (int i = 0; i < newStcos.size(); ++i) {
                Mp4StcoBox newStco = newStcos.get(i);
                Mp4StcoBox stco = stcos.get(i);
                logger.finer("stco:Original First Offset" + stco.getFirstOffSet());
                logger.finer("stco:Original Diff" + (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos()));
                logger.finer("stco:Original Mdat Pos" + mdatHeader.getFilePos());
                logger.finer("stco:New First Offset" + newStco.getFirstOffSet());
                logger.finer("stco:New Diff" + (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos()));
                logger.finer("stco:New Mdat Pos" + newMdatHeader.getFilePos());
                if (i == 0) {
                    int diff = (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos());
                    if ((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() != (long)diff) {
                        int discrepancy = (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() - (long)diff);
                        throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(discrepancy));
                    }
                    shift = stco.getFirstOffSet() - newStco.getFirstOffSet();
                    continue;
                }
                if (shift == stco.getFirstOffSet() - newStco.getFirstOffSet()) continue;
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(shift));
            }
        }
        catch (Exception e) {
            if (e instanceof CannotWriteException) {
                throw (CannotWriteException)e;
            }
            e.printStackTrace();
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED.getMsg() + ":" + e.getMessage());
        }
        finally {
            fc.close();
        }
        logger.config("File has been written correctly");
    }

    public void delete(Tag tag, Path file) throws CannotWriteException {
        tag = new Mp4Tag();
        this.write(tag, file);
    }

    private void writeNoExistingUdtaAtom(SeekableByteChannel fc, ByteBuffer newIlstData, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, List<Mp4StcoBox> stcos, int sizeOfExistingTopLevelFreeAtom, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, Mp4BoxHeader neroTagsHeader) throws IOException {
        long endOfOriginalMoovAtom = moovHeader.getFileEndPos();
        Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
        Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + newIlstData.limit());
        Mp4BoxHeader udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
        udtaHeader.setLength(8 + metaBox.getHeader().getLength());
        boolean isMdatDataMoved = this.adjustStcosIfNoSuitableTopLevelAtom(sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, udtaHeader.getLength(), stcos, moovHeader, mdatHeader);
        moovHeader.setLength(moovHeader.getLength() + udtaHeader.getLength());
        fc.position(moovHeader.getFilePos());
        fc.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        fc.write(moovBuffer);
        if (!isMdatDataMoved) {
            logger.severe("Writing:Option 5.1;No udta atom");
            fc.write(udtaHeader.getHeaderData());
            fc.write(metaBox.getHeader().getHeaderData());
            fc.write(metaBox.getData());
            fc.write(hdlrBox.getHeader().getHeaderData());
            fc.write(hdlrBox.getData());
            fc.write(newIlstData);
            this.adjustTopLevelFreeAtom(fc, sizeOfExistingTopLevelFreeAtom, udtaHeader.getLength());
        } else {
            logger.severe("Writing:Option 5.2;No udta atom, not enough free space");
            fc.position(endOfOriginalMoovAtom);
            ShiftData.shiftDataByOffsetToMakeSpace(fc, udtaHeader.getLength());
            fc.position(endOfOriginalMoovAtom);
            fc.write(udtaHeader.getHeaderData());
            fc.write(metaBox.getHeader().getHeaderData());
            fc.write(metaBox.getData());
            fc.write(hdlrBox.getHeader().getHeaderData());
            fc.write(hdlrBox.getData());
            fc.write(newIlstData);
        }
    }

    private void writeNoExistingMetaAtom(Mp4BoxHeader udtaHeader, SeekableByteChannel fc, ByteBuffer newIlstData, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, List<Mp4StcoBox> stcos, int sizeOfExistingTopLevelFreeAtom, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, Mp4BoxHeader neroTagsHeader, int positionOfStartOfIlstAtomInMoovBuffer, int existingSizeOfIlstData, int topLevelFreeSize, int additionalMetaSizeThatWontFitWithinMetaAtom) throws IOException {
        int newIlstDataSize = newIlstData.limit();
        int existingMoovHeaderDataLength = moovHeader.getDataLength();
        long endOfOriginalMoovAtom = moovHeader.getFileEndPos();
        int existingUdtaLength = udtaHeader.getLength();
        int existingUdtaDataLength = udtaHeader.getDataLength();
        Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
        Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + newIlstDataSize);
        udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
        udtaHeader.setLength(8 + metaBox.getHeader().getLength() + existingUdtaDataLength);
        int increaseInSizeOfUdtaAtom = udtaHeader.getDataLength() - existingUdtaDataLength;
        boolean isMdatDataMoved = this.adjustStcosIfNoSuitableTopLevelAtom(sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, increaseInSizeOfUdtaAtom, stcos, moovHeader, mdatHeader);
        moovHeader.setLength(moovHeader.getLength() + increaseInSizeOfUdtaAtom);
        fc.position(moovHeader.getFilePos());
        fc.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        moovBuffer.limit(existingMoovHeaderDataLength - existingUdtaLength);
        fc.write(moovBuffer);
        fc.write(udtaHeader.getHeaderData());
        if (moovBuffer.position() + 8 < moovBuffer.capacity()) {
            moovBuffer.limit(moovBuffer.capacity());
            moovBuffer.position(moovBuffer.position() + 8);
            fc.write(moovBuffer);
        }
        if (!isMdatDataMoved) {
            logger.severe("Writing:Option 6.1;No meta atom");
            fc.write(metaBox.getHeader().getHeaderData());
            fc.write(metaBox.getData());
            fc.write(hdlrBox.getHeader().getHeaderData());
            fc.write(hdlrBox.getData());
            fc.write(newIlstData);
            this.writeRestOfMoovHeaderAfterNewIlistAndAmendedTopLevelFreeAtom(fc, positionOfStartOfIlstAtomInMoovBuffer, moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, topLevelFreeSize, neroTagsHeader, existingSizeOfIlstData);
        } else {
            logger.severe("Writing:Option 6.2;No meta atom, not enough free space");
            fc.position(endOfOriginalMoovAtom);
            ShiftData.shiftDataByOffsetToMakeSpace(fc, metaBox.getHeader().getLength());
            fc.position(endOfOriginalMoovAtom);
            fc.write(metaBox.getHeader().getHeaderData());
            fc.write(metaBox.getData());
            fc.write(hdlrBox.getHeader().getHeaderData());
            fc.write(hdlrBox.getData());
            fc.write(newIlstData);
        }
    }

    private void writeHaveExistingMetadata(Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader, SeekableByteChannel fc, int positionOfStartOfIlstAtomInMoovBuffer, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, List<Mp4StcoBox> stcos, int topLevelFreeSize, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, ByteBuffer newIlstData, Mp4BoxHeader neroTagsHeader, int existingSizeOfIlstData) throws IOException {
        long endOfOriginalMoovAtom = moovHeader.getFileEndPos();
        int sizeRequiredByNewIlstAtom = newIlstData.limit();
        int additionalMetaSizeThatWontFitWithinMetaAtom = sizeRequiredByNewIlstAtom - existingSizeOfIlstData;
        boolean isMdatDataMoved = this.adjustStcosIfNoSuitableTopLevelAtom(topLevelFreeSize, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, additionalMetaSizeThatWontFitWithinMetaAtom, stcos, moovHeader, mdatHeader);
        this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, udtaHeader, metaHeader);
        fc.position(moovHeader.getFilePos());
        fc.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        moovBuffer.limit(positionOfStartOfIlstAtomInMoovBuffer);
        fc.write(moovBuffer);
        if (!isMdatDataMoved) {
            logger.severe("Writing:Option 7.1, Increased Data");
            fc.write(newIlstData);
            this.writeRestOfMoovHeaderAfterNewIlistAndAmendedTopLevelFreeAtom(fc, positionOfStartOfIlstAtomInMoovBuffer, moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, topLevelFreeSize, neroTagsHeader, existingSizeOfIlstData);
        } else {
            logger.severe("Writing:Option 7.2 Increased Data, not enough free space");
            fc.position(endOfOriginalMoovAtom);
            ShiftData.shiftDataByOffsetToMakeSpace(fc, additionalMetaSizeThatWontFitWithinMetaAtom);
            fc.position(moovHeader.getFilePos() + 8L + (long)positionOfStartOfIlstAtomInMoovBuffer);
            fc.write(newIlstData);
            moovBuffer.limit(moovBuffer.capacity());
            moovBuffer.position(positionOfStartOfIlstAtomInMoovBuffer + existingSizeOfIlstData);
            if (moovBuffer.position() < moovBuffer.capacity()) {
                fc.write(moovBuffer);
            }
        }
    }

    private void writeRestOfMoovHeaderAfterNewIlistAndAmendedTopLevelFreeAtom(SeekableByteChannel fc, int positionOfStartOfIlstAtomInMoovBuffer, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int additionalMetaSizeThatWontFitWithinMetaAtom, int topLevelFreeSize, Mp4BoxHeader neroTagsHeader, int existingSizeOfIlstData) throws IOException {
        if (neroTagsHeader != null) {
            moovBuffer.limit(moovBuffer.capacity());
            moovBuffer.position(positionOfStartOfIlstAtomInMoovBuffer + existingSizeOfIlstData);
            this.writeFromEndOfIlstToNeroTagsAndMakeNeroFree(moovHeader, moovBuffer, fc, neroTagsHeader);
            this.adjustTopLevelFreeAtom(fc, topLevelFreeSize, additionalMetaSizeThatWontFitWithinMetaAtom);
        } else {
            moovBuffer.limit(moovBuffer.capacity());
            moovBuffer.position(positionOfStartOfIlstAtomInMoovBuffer + existingSizeOfIlstData);
            if (moovBuffer.position() < moovBuffer.capacity()) {
                fc.write(moovBuffer);
            }
            this.adjustTopLevelFreeAtom(fc, topLevelFreeSize, additionalMetaSizeThatWontFitWithinMetaAtom);
        }
    }

    private void writeFromEndOfIlstToNeroTagsAndMakeNeroFree(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, SeekableByteChannel fc, Mp4BoxHeader neroTagsHeader) throws IOException {
        moovBuffer.limit((int)(neroTagsHeader.getFilePos() - (moovHeader.getFilePos() + 8L)));
        fc.write(moovBuffer);
        this.convertandWriteTagsAtomToFreeAtom(fc, neroTagsHeader);
    }

    private void adjustTopLevelFreeAtom(SeekableByteChannel fc, int sizeOfExistingTopLevelAtom, int additionalMetaSizeThatWontFitWithinMetaAtom) throws IOException {
        if (sizeOfExistingTopLevelAtom - 8 >= additionalMetaSizeThatWontFitWithinMetaAtom) {
            logger.config("Writing:Option 6;Larger Size can use top free atom");
            Mp4FreeBox freeBox = new Mp4FreeBox(sizeOfExistingTopLevelAtom - 8 - additionalMetaSizeThatWontFitWithinMetaAtom);
            fc.write(freeBox.getHeader().getHeaderData());
            fc.write(freeBox.getData());
        } else if (sizeOfExistingTopLevelAtom == additionalMetaSizeThatWontFitWithinMetaAtom) {
            logger.config("Writing:Option 7;Larger Size uses top free atom including header");
        }
    }

    private boolean adjustStcosIfNoSuitableTopLevelAtom(int topLevelFreeSize, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, int additionalSizeRequired, List<Mp4StcoBox> stcos, Mp4BoxHeader moovHeader, Mp4BoxHeader mdatHeader) {
        if (mdatHeader.getFilePos() > moovHeader.getFilePos() && (!topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata || topLevelFreeSize - 8 < additionalSizeRequired && topLevelFreeSize != additionalSizeRequired)) {
            for (Mp4StcoBox stoc : stcos) {
                stoc.adjustOffsets(additionalSizeRequired);
            }
            return true;
        }
        return false;
    }
}

