/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Tracer {
    public static HitResult rayTrace(Entity source, float partialTicks, double reach, boolean fluids) {
        EntityHitResult entityHit;
        BlockHitResult blockHit = Tracer.rayTraceBlocks(source, partialTicks, reach, fluids);
        double maxSqDist = reach * reach;
        if (blockHit != null) {
            maxSqDist = blockHit.m_82450_().m_82557_(source.m_20299_(partialTicks));
        }
        return (entityHit = Tracer.rayTraceEntities(source, partialTicks, reach, maxSqDist)) == null ? blockHit : entityHit;
    }

    public static BlockHitResult rayTraceBlocks(Entity source, float partialTicks, double reach, boolean fluids) {
        Vec3 pos = source.m_20299_(partialTicks);
        Vec3 rotation = source.m_20252_(partialTicks);
        Vec3 reachEnd = pos.m_82520_(rotation.f_82479_ * reach, rotation.f_82480_ * reach, rotation.f_82481_ * reach);
        return source.f_19853_.m_45547_(new ClipContext(pos, reachEnd, ClipContext.Block.OUTLINE, fluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, source));
    }

    public static EntityHitResult rayTraceEntities(Entity source, float partialTicks, double reach, double maxSqDist) {
        Vec3 pos = source.m_20299_(partialTicks);
        Vec3 reachVec = source.m_20252_(partialTicks).m_82490_(reach);
        AABB box = source.m_142469_().m_82369_(reachVec).m_82400_(1.0);
        return Tracer.rayTraceEntities(source, pos, pos.m_82549_(reachVec), box, e -> !e.m_5833_() && e.m_5829_(), maxSqDist);
    }

    public static EntityHitResult rayTraceEntities(Entity source, Vec3 start, Vec3 end, AABB box, Predicate<Entity> predicate, double maxSqDistance) {
        Level world = source.f_19853_;
        double targetDistance = maxSqDistance;
        Entity target = null;
        Vec3 targetHitPos = null;
        for (Entity current : world.m_6249_(source, box, predicate)) {
            Vec3 currentHitPos;
            double currentDistance;
            AABB currentBox = current.m_142469_().m_82400_((double)current.m_6143_());
            Optional currentHit = currentBox.m_82371_(start, end);
            if (currentBox.m_82390_(start)) {
                if (!(targetDistance >= 0.0)) continue;
                target = current;
                targetHitPos = currentHit.orElse(start);
                targetDistance = 0.0;
                continue;
            }
            if (!currentHit.isPresent() || !((currentDistance = start.m_82557_(currentHitPos = (Vec3)currentHit.get())) < targetDistance) && targetDistance != 0.0) continue;
            if (current.m_20201_() == source.m_20201_()) {
                if (targetDistance != 0.0) continue;
                target = current;
                targetHitPos = currentHitPos;
                continue;
            }
            target = current;
            targetHitPos = currentHitPos;
            targetDistance = currentDistance;
        }
        if (target == null) {
            return null;
        }
        return new EntityHitResult(target, targetHitPos);
    }
}

