/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messenger {
    public static final Logger LOG = LoggerFactory.getLogger((String)"Messaging System");
    private static final Pattern colorExtract = Pattern.compile("#([0-9a-fA-F]{6})");

    public static Style parseStyle(String style) {
        Style myStyle = Style.f_131099_.m_131140_(ChatFormatting.WHITE);
        for (CarpetFormatting cf : CarpetFormatting.values()) {
            myStyle = cf.apply(style, myStyle);
        }
        return myStyle;
    }

    public static String heatmap_color(double actual, double reference) {
        String color = "g";
        if (actual >= 0.0) {
            color = "e";
        }
        if (actual > 0.5 * reference) {
            color = "y";
        }
        if (actual > 0.8 * reference) {
            color = "r";
        }
        if (actual > reference) {
            color = "m";
        }
        return color;
    }

    public static String creatureTypeColor(MobCategory type) {
        return switch (type) {
            case MobCategory.MONSTER -> "n";
            case MobCategory.CREATURE -> "e";
            case MobCategory.AMBIENT -> "f";
            case MobCategory.WATER_CREATURE -> "v";
            case MobCategory.WATER_AMBIENT -> "q";
            default -> "w";
        };
    }

    private static MutableComponent getChatComponentFromDesc(String message, MutableComponent previousMessage) {
        if (((String)message).equalsIgnoreCase("")) {
            return new TextComponent("");
        }
        if (Character.isWhitespace(((String)message).charAt(0))) {
            message = "w" + (String)message;
        }
        int limit = ((String)message).indexOf(32);
        Object desc = message;
        String str = "";
        if (limit >= 0) {
            desc = ((String)message).substring(0, limit);
            str = ((String)message).substring(limit + 1);
        }
        if (previousMessage == null) {
            TextComponent text = new TextComponent(str);
            text.m_6270_(Messenger.parseStyle((String)desc));
            return text;
        }
        Style previousStyle = previousMessage.m_7383_();
        MutableComponent ret = previousMessage;
        previousMessage.m_6270_(switch (((String)desc).charAt(0)) {
            case '?' -> previousStyle.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ((String)message).substring(1)));
            case '!' -> previousStyle.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, ((String)message).substring(1)));
            case '^' -> previousStyle.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Messenger.c(((String)message).substring(1))));
            case '@' -> previousStyle.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ((String)message).substring(1)));
            case '&' -> previousStyle.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ((String)message).substring(1)));
            default -> {
                ret = new TextComponent(str);
                ret.m_6270_(Messenger.parseStyle((String)desc));
                yield previousStyle;
            }
        });
        return ret;
    }

    public static Component tp(String desc, Vec3 pos) {
        return Messenger.tp(desc, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static Component tp(String desc, BlockPos pos) {
        return Messenger.tp(desc, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Component tp(String desc, double x, double y, double z) {
        return Messenger.tp(desc, (float)x, (float)y, (float)z);
    }

    public static Component tp(String desc, float x, float y, float z) {
        return Messenger.getCoordsTextComponent(desc, x, y, z, false);
    }

    public static Component tp(String desc, int x, int y, int z) {
        return Messenger.getCoordsTextComponent(desc, x, y, z, true);
    }

    public static Component dbl(String style, double double_value) {
        return Messenger.c(String.format("%s %.1f", style, double_value), String.format("^w %f", double_value));
    }

    public static Component dbls(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%.1f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static Component dblf(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static Component dblt(String style, double ... doubles) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            components.add(String.format("%s %s%.1f", style, prefix, dbl));
            components.add("?" + dbl);
            components.add("^w " + dbl);
            prefix = ", ";
        }
        components.add(style + "  ]");
        return Messenger.c(components.toArray(new Object[0]));
    }

    private static Component getCoordsTextComponent(String style, float x, float y, float z, boolean isInt) {
        String command;
        String text;
        if (isInt) {
            text = String.format("%s [ %d, %d, %d ]", style, (int)x, (int)y, (int)z);
            command = String.format("!/tp %d %d %d", (int)x, (int)y, (int)z);
        } else {
            text = String.format("%s [ %.1f, %.1f, %.1f]", style, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
            command = String.format("!/tp %.3f %.3f %.3f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        return Messenger.c(text, command);
    }

    public static void m(CommandSourceStack source, Object ... fields) {
        if (source != null) {
            source.m_81354_(Messenger.c(fields), source.m_81377_() != null && source.m_81377_().m_129880_(Level.f_46428_) != null);
        }
    }

    public static void m(Player player, Object ... fields) {
        player.m_6352_(Messenger.c(fields), Util.f_137441_);
    }

    public static Component c(Object ... fields) {
        TextComponent message = new TextComponent("");
        MutableComponent previousComponent = null;
        for (Object o : fields) {
            if (o instanceof MutableComponent) {
                message.m_7220_((Component)((MutableComponent)o));
                previousComponent = (MutableComponent)o;
                continue;
            }
            String txt = o.toString();
            MutableComponent comp = Messenger.getChatComponentFromDesc(txt, previousComponent);
            if (comp != previousComponent) {
                message.m_7220_((Component)comp);
            }
            previousComponent = comp;
        }
        return message;
    }

    public static Component s(String text) {
        return Messenger.s(text, "");
    }

    public static Component s(String text, String style) {
        TextComponent message = new TextComponent(text);
        message.m_6270_(Messenger.parseStyle(style));
        return message;
    }

    public static void send(Player player, Collection<Component> lines) {
        lines.forEach(message -> player.m_6352_(message, Util.f_137441_));
    }

    public static void send(CommandSourceStack source, Collection<Component> lines) {
        lines.stream().forEachOrdered(s -> source.m_81354_(s, false));
    }

    public static void print_server_message(MinecraftServer server, String message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message);
        }
        server.m_6352_((Component)new TextComponent(message), Util.f_137441_);
        Component txt = Messenger.c("gi " + message);
        for (ServerPlayer entityplayer : server.m_6846_().m_11314_()) {
            entityplayer.m_9146_(txt, ChatType.SYSTEM, Util.f_137441_);
        }
    }

    public static void print_server_message(MinecraftServer server, Component message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message.getString());
        }
        server.m_6352_(message, Util.f_137441_);
        for (ServerPlayer entityplayer : server.m_6846_().m_11314_()) {
            entityplayer.m_9146_(message, ChatType.SYSTEM, Util.f_137441_);
        }
    }

    public static enum CarpetFormatting {
        ITALIC('i', (s, f) -> s.m_131155_(Boolean.valueOf(true))),
        STRIKE('s', (s, f) -> s.m_131157_(ChatFormatting.STRIKETHROUGH)),
        UNDERLINE('u', (s, f) -> s.m_131157_(ChatFormatting.UNDERLINE)),
        BOLD('b', (s, f) -> s.m_131136_(Boolean.valueOf(true))),
        OBFUSCATE('o', (s, f) -> s.m_131157_(ChatFormatting.OBFUSCATED)),
        WHITE('w', (s, f) -> s.m_131140_(ChatFormatting.WHITE)),
        YELLOW('y', (s, f) -> s.m_131140_(ChatFormatting.YELLOW)),
        LIGHT_PURPLE('m', (s, f) -> s.m_131140_(ChatFormatting.LIGHT_PURPLE)),
        RED('r', (s, f) -> s.m_131140_(ChatFormatting.RED)),
        AQUA('c', (s, f) -> s.m_131140_(ChatFormatting.AQUA)),
        GREEN('l', (s, f) -> s.m_131140_(ChatFormatting.GREEN)),
        BLUE('t', (s, f) -> s.m_131140_(ChatFormatting.BLUE)),
        DARK_GRAY('f', (s, f) -> s.m_131140_(ChatFormatting.DARK_GRAY)),
        GRAY('g', (s, f) -> s.m_131140_(ChatFormatting.GRAY)),
        GOLD('d', (s, f) -> s.m_131140_(ChatFormatting.GOLD)),
        DARK_PURPLE('p', (s, f) -> s.m_131140_(ChatFormatting.DARK_PURPLE)),
        DARK_RED('n', (s, f) -> s.m_131140_(ChatFormatting.DARK_RED)),
        DARK_AQUA('q', (s, f) -> s.m_131140_(ChatFormatting.DARK_AQUA)),
        DARK_GREEN('e', (s, f) -> s.m_131140_(ChatFormatting.DARK_GREEN)),
        DARK_BLUE('v', (s, f) -> s.m_131140_(ChatFormatting.DARK_BLUE)),
        BLACK('k', (s, f) -> s.m_131140_(ChatFormatting.BLACK)),
        COLOR('#', (s, f) -> {
            TextColor color = TextColor.m_131268_((String)("#" + f));
            return color == null ? s : s.m_131148_(color);
        }, s -> {
            Matcher m = colorExtract.matcher((CharSequence)s);
            return m.find() ? m.group(1) : null;
        });

        public char code;
        public BiFunction<Style, String, Style> applier;
        public Function<String, String> container;

        private CarpetFormatting(char code, BiFunction<Style, String, Style> applier) {
            this(code, applier, s -> s.indexOf(code) >= 0 ? Character.toString(code) : null);
        }

        private CarpetFormatting(char code, BiFunction<Style, String, Style> applier, Function<String, String> container) {
            this.code = code;
            this.applier = applier;
            this.container = container;
        }

        public Style apply(String format, Style previous) {
            String fmt = this.container.apply(format);
            if (fmt != null) {
                return this.applier.apply(previous, fmt);
            }
            return previous;
        }
    }
}

