/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.logging.helper.TNTLogHelper;
import dev.dubhe.curtain.features.rules.fakes.TntEntityInterface;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PrimedTnt.class})
public abstract class PrimedTntMixin
extends Entity
implements TntEntityInterface {
    private TNTLogHelper logHelper;
    private boolean mergeBool = false;
    private int mergedTNT = 1;

    @Shadow
    public abstract int m_32100_();

    public PrimedTntMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void modifyTNTAngle(Level world, double x, double y, double z, LivingEntity entity, CallbackInfo ci) {
        if (CurtainRules.hardcodeTNTAngle != -1.0) {
            this.m_20334_(-Math.sin(CurtainRules.hardcodeTNTAngle) * 0.02, 0.2, -Math.cos(CurtainRules.hardcodeTNTAngle) * 0.02);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void initTNTLoggerPrime(EntityType<? extends PrimedTnt> type, Level world, CallbackInfo ci) {
        if (!world.f_46443_) {
            this.logHelper = new TNTLogHelper();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void initTracker(CallbackInfo ci) {
        if (this.logHelper != null && !this.logHelper.initialized) {
            this.logHelper.onPrimed(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20184_());
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void initTNTLogger(Level world, double x, double y, double z, LivingEntity entity, CallbackInfo ci) {
        if (CurtainRules.tntPrimerMomentumRemoved) {
            this.m_20334_(0.0, 0.2f, 0.0);
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    private void onExplode(CallbackInfo ci) {
        if (this.logHelper != null) {
            this.logHelper.onExploded(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19853_.m_46467_());
        }
        if (this.mergedTNT > 1) {
            for (int i = 0; i < this.mergedTNT - 1; ++i) {
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 16.0f), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/PrimedTnt;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=2)})
    private void tryMergeTnt(CallbackInfo ci) {
        if (CurtainRules.mergeTNT) {
            Vec3 velocity = this.m_20184_();
            if (!this.f_19853_.f_46443_ && this.mergeBool && velocity.f_82479_ == 0.0 && velocity.f_82480_ == 0.0 && velocity.f_82481_ == 0.0) {
                this.mergeBool = false;
                for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_142469_())) {
                    if (!(entity instanceof PrimedTnt) || entity.m_146910_()) continue;
                    PrimedTnt entityTNTPrimed = (PrimedTnt)entity;
                    Vec3 tntVelocity = entityTNTPrimed.m_20184_();
                    if (tntVelocity.f_82479_ != 0.0 || tntVelocity.f_82480_ != 0.0 || tntVelocity.f_82481_ != 0.0 || this.m_20185_() != entityTNTPrimed.m_20185_() || this.m_20189_() != entityTNTPrimed.m_20189_() || this.m_20186_() != entityTNTPrimed.m_20186_() || this.m_32100_() != entityTNTPrimed.m_32100_()) continue;
                    this.mergedTNT += ((TntEntityInterface)entityTNTPrimed).getMergedTNT();
                    entityTNTPrimed.m_146870_();
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/PrimedTnt;setFuse(I)V")})
    private void setMergeable(CallbackInfo ci) {
        Vec3 velocity = this.m_20184_();
        if (!(this.f_19853_.f_46443_ || velocity.f_82480_ == 0.0 && velocity.f_82479_ == 0.0 && velocity.f_82481_ == 0.0)) {
            this.mergeBool = true;
        }
    }

    @Override
    public int getMergedTNT() {
        return this.mergedTNT;
    }
}

