/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins;

import dev.dubhe.curtain.utils.SpawnReporter;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public abstract class NaturalSpawnerMixin {
    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V"))
    private static void spawnEntity(ServerLevel world, Entity entity_1, MobCategory group, ServerLevel world2, ChunkAccess chunk, BlockPos pos, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner) {
        if (SpawnReporter.track_spawns > 0L && SpawnReporter.local_spawns != null) {
            SpawnReporter.registerSpawn((Mob)entity_1, group, entity_1.m_142538_());
        }
        if (!SpawnReporter.mock_spawns) {
            world.m_47205_(entity_1);
        }
    }

    @Redirect(method={"spawnForChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner;spawnCategoryForChunk(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"))
    private static void spawnMultipleTimes(MobCategory category, ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner) {
        for (int i = 0; i < SpawnReporter.spawn_tries.get(category); ++i) {
            NaturalSpawner.m_47045_((MobCategory)category, (ServerLevel)world, (LevelChunk)chunk, (NaturalSpawner.SpawnPredicate)checker, (NaturalSpawner.AfterSpawnCallback)runner);
        }
    }

    @Inject(method={"spawnForChunk"}, at={@At(value="HEAD")})
    private static void checkSpawns(ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnState info, boolean spawnAnimals, boolean spawnMonsters, boolean shouldSpawnAnimals, CallbackInfo ci) {
        if (SpawnReporter.track_spawns > 0L) {
            for (MobCategory entityCategory : NaturalSpawner.f_46979_) {
                if (!spawnAnimals && entityCategory.m_21609_() || !spawnMonsters && !entityCategory.m_21609_() || !shouldSpawnAnimals && entityCategory.m_21610_()) continue;
                ResourceKey dim = world.m_46472_();
                int newCap = entityCategory.m_21608_();
                int int_2 = SpawnReporter.chunkCounts.get(dim);
                int int_3 = newCap * int_2 / SpawnReporter.MAGIC_NUMBER;
                int mobCount = info.m_47148_().getInt((Object)entityCategory);
                if (SpawnReporter.track_spawns > 0L && !SpawnReporter.first_chunk_marker.contains(entityCategory)) {
                    SpawnReporter.first_chunk_marker.add(entityCategory);
                    Pair key = Pair.of((Object)dim, (Object)entityCategory);
                    int spawnTries = SpawnReporter.spawn_tries.get(entityCategory);
                    SpawnReporter.spawn_attempts.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_attempts.get(key) + (long)spawnTries);
                    SpawnReporter.spawn_cap_count.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_cap_count.get(key) + (long)mobCount);
                }
                if (mobCount > int_3 && !SpawnReporter.mock_spawns) continue;
                SpawnReporter.local_spawns.putIfAbsent(entityCategory, 0L);
            }
        }
    }
}

