/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.menu;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.dubhe.curtain.api.menu.CustomMenu;
import dev.dubhe.curtain.api.menu.control.AutoResetButton;
import dev.dubhe.curtain.api.menu.control.Button;
import dev.dubhe.curtain.api.menu.control.RadioList;
import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.helpers.EntityPlayerActionPack;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FakePlayerInventoryMenu
extends CustomMenu {
    public final NonNullList<ItemStack> items;
    public final NonNullList<ItemStack> armor;
    public final NonNullList<ItemStack> offhand;
    private final NonNullList<ItemStack> buttons = NonNullList.m_122780_((int)13, (Object)ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> compartments;
    private final Player player;
    private final EntityPlayerActionPack ap;

    public FakePlayerInventoryMenu(Player player) {
        this.player = player;
        this.items = this.player.m_150109_().f_35974_;
        this.armor = this.player.m_150109_().f_35975_;
        this.offhand = this.player.m_150109_().f_35976_;
        this.ap = ((IServerPlayer)this.player).getActionPack();
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand, this.buttons);
        this.createButton();
        this.ap.setSlot(1);
    }

    public int m_6643_() {
        return this.items.size() + this.armor.size() + this.offhand.size() + this.buttons.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStack : this.armor) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStack : this.offhand) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        if (pair != null) {
            return (ItemStack)((NonNullList)pair.getFirst()).get(((Integer)pair.getSecond()).intValue());
        }
        return ItemStack.f_41583_;
    }

    public Pair<NonNullList<ItemStack>, Integer> getItemSlot(int slot) {
        switch (slot) {
            case 0: {
                return new Pair(this.buttons, (Object)0);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Pair(this.armor, (Object)(4 - slot));
            }
            case 5: 
            case 6: {
                return new Pair(this.buttons, (Object)(slot - 4));
            }
            case 7: {
                return new Pair(this.offhand, (Object)0);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return new Pair(this.buttons, (Object)(slot - 5));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return new Pair(this.items, (Object)(slot - 9));
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new Pair(this.items, (Object)(slot - 45));
            }
        }
        return null;
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).m_41619_()) {
            return ContainerHelper.m_18969_((List)list, (int)slot, (int)amount);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).m_41619_()) {
            ItemStack itemStack = (ItemStack)list.get(slot);
            list.set(slot, (Object)ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null) {
            list.set(slot, (Object)stack);
        }
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.player.m_6084_() && !(player.m_20280_((Entity)this.player) > 64.0);
    }

    public void m_6211_() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    private void createButton() {
        ArrayList<Button> hotBarList = new ArrayList<Button>();
        for (int i = 0; i < 9; ++i) {
            MutableComponent hotBarComponent = TranslationHelper.translate("curtain.rules.open_fake_player_inventory.menu.slot", ChatFormatting.WHITE, Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false)), new Object[]{i + 1});
            boolean defaultState = i == 0;
            Button button = new Button(defaultState, i + 1, (Component)hotBarComponent, (Component)hotBarComponent);
            int finalI = i + 1;
            button.addTurnOnFunction(() -> this.ap.setSlot(finalI));
            this.addButton(i + 9, button);
            hotBarList.add(button);
        }
        this.addButtonList(new RadioList(hotBarList, true));
        AutoResetButton stopAll = new AutoResetButton("curtain.rules.open_fake_player_inventory.menu.stop_all");
        Button attackInterval14 = new Button(false, "curtain.rules.open_fake_player_inventory.menu.attack_interval_14");
        Button attackContinuous = new Button(false, "curtain.rules.open_fake_player_inventory.menu.attack_continuous");
        Button useContinuous = new Button(false, "curtain.rules.open_fake_player_inventory.menu.use_continuous");
        stopAll.addTurnOnFunction(() -> {
            attackInterval14.turnOffWithoutFunction();
            attackContinuous.turnOffWithoutFunction();
            useContinuous.turnOffWithoutFunction();
            this.ap.stopAll();
        });
        attackInterval14.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.interval(14));
            attackContinuous.turnOffWithoutFunction();
        });
        attackInterval14.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        attackContinuous.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.continuous());
            attackInterval14.turnOffWithoutFunction();
        });
        attackContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        useContinuous.addTurnOnFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.continuous()));
        useContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.once()));
        this.addButton(0, stopAll);
        this.addButton(5, attackInterval14);
        this.addButton(6, attackContinuous);
        this.addButton(8, useContinuous);
    }
}

