/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.helpers;

import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import dev.dubhe.curtain.utils.Tracer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EntityPlayerActionPack {
    private final ServerPlayer player;
    private final Map<ActionType, Action> actions = new TreeMap<ActionType, Action>();
    private BlockPos currentBlock;
    private int blockHitDelay;
    private boolean isHittingBlock;
    private float curBlockDamageMP;
    private boolean sneaking;
    private boolean sprinting;
    private float forward;
    private float strafing;
    private int itemUseCooldown;

    public EntityPlayerActionPack(ServerPlayer playerIn) {
        this.player = playerIn;
        this.stopAll();
    }

    public void copyFrom(EntityPlayerActionPack other) {
        this.actions.putAll(other.actions);
        this.currentBlock = other.currentBlock;
        this.blockHitDelay = other.blockHitDelay;
        this.isHittingBlock = other.isHittingBlock;
        this.curBlockDamageMP = other.curBlockDamageMP;
        this.sneaking = other.sneaking;
        this.sprinting = other.sprinting;
        this.forward = other.forward;
        this.strafing = other.strafing;
        this.itemUseCooldown = other.itemUseCooldown;
    }

    public EntityPlayerActionPack start(ActionType type, Action action) {
        Action previous = this.actions.remove((Object)type);
        if (previous != null) {
            type.stop(this.player, previous);
        }
        if (action != null) {
            this.actions.put(type, action);
            type.start(this.player, action);
        }
        return this;
    }

    public EntityPlayerActionPack setSneaking(boolean doSneak) {
        this.sneaking = doSneak;
        this.player.m_20260_(doSneak);
        if (this.sprinting && this.sneaking) {
            this.setSprinting(false);
        }
        return this;
    }

    public EntityPlayerActionPack setSprinting(boolean doSprint) {
        this.sprinting = doSprint;
        this.player.m_6858_(doSprint);
        if (this.sneaking && this.sprinting) {
            this.setSneaking(false);
        }
        return this;
    }

    public EntityPlayerActionPack setForward(float value) {
        this.forward = value;
        return this;
    }

    public EntityPlayerActionPack setStrafing(float value) {
        this.strafing = value;
        return this;
    }

    public EntityPlayerActionPack look(Direction direction) {
        switch (direction) {
            case NORTH: {
                return this.look(180.0f, 0.0f);
            }
            case SOUTH: {
                return this.look(0.0f, 0.0f);
            }
            case EAST: {
                return this.look(-90.0f, 0.0f);
            }
            case WEST: {
                return this.look(90.0f, 0.0f);
            }
            case UP: {
                return this.look(this.player.m_146908_(), -90.0f);
            }
            case DOWN: {
                return this.look(this.player.m_146908_(), 90.0f);
            }
        }
        return this;
    }

    public EntityPlayerActionPack look(Vec2 rotation) {
        return this.look(rotation.f_82470_, rotation.f_82471_);
    }

    public EntityPlayerActionPack look(float yaw, float pitch) {
        this.player.m_146922_(yaw % 360.0f);
        this.player.m_146926_(Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f));
        return this;
    }

    public EntityPlayerActionPack lookAt(Vec3 position) {
        this.player.m_7618_(EntityAnchorArgument.Anchor.EYES, position);
        return this;
    }

    public EntityPlayerActionPack turn(float yaw, float pitch) {
        return this.look(this.player.m_146908_() + yaw, this.player.m_146909_() + pitch);
    }

    public EntityPlayerActionPack turn(Vec2 rotation) {
        return this.turn(rotation.f_82470_, rotation.f_82471_);
    }

    public EntityPlayerActionPack stopMovement() {
        this.setSneaking(false);
        this.setSprinting(false);
        this.forward = 0.0f;
        this.strafing = 0.0f;
        return this;
    }

    public EntityPlayerActionPack stopAll() {
        for (ActionType type : this.actions.keySet()) {
            type.stop(this.player, this.actions.get((Object)type));
        }
        this.actions.clear();
        return this.stopMovement();
    }

    public EntityPlayerActionPack mount(boolean onlyRideables) {
        List entities = onlyRideables ? this.player.f_19853_.m_6249_((Entity)this.player, this.player.m_142469_().m_82377_(3.0, 1.0, 3.0), e -> e instanceof Minecart || e instanceof Boat || e instanceof AbstractHorse) : this.player.f_19853_.m_45933_((Entity)this.player, this.player.m_142469_().m_82377_(3.0, 1.0, 3.0));
        if (entities.size() == 0) {
            return this;
        }
        Entity closest = null;
        double distance = Double.POSITIVE_INFINITY;
        Entity currentVehicle = this.player.m_20202_();
        for (Entity e2 : entities) {
            double dd;
            if (e2 == this.player || currentVehicle == e2 || !((dd = this.player.m_20280_(e2)) < distance)) continue;
            distance = dd;
            closest = e2;
        }
        if (closest == null) {
            return this;
        }
        if (closest instanceof AbstractHorse && onlyRideables) {
            ((AbstractHorse)closest).m_6071_((Player)this.player, InteractionHand.MAIN_HAND);
        } else {
            this.player.m_7998_(closest, true);
        }
        return this;
    }

    public EntityPlayerActionPack dismount() {
        this.player.m_8127_();
        return this;
    }

    public void onUpdate() {
        float vel;
        HashMap<ActionType, Boolean> actionAttempts = new HashMap<ActionType, Boolean>();
        this.actions.entrySet().removeIf(e -> ((Action)e.getValue()).done);
        for (Map.Entry<ActionType, Action> e2 : this.actions.entrySet()) {
            Action using;
            Boolean actionStatus;
            Action action = e2.getValue();
            if (!(actionAttempts.getOrDefault((Object)ActionType.USE, false).booleanValue() && e2.getKey() == ActionType.ATTACK || (actionStatus = action.tick(this, e2.getKey())) == null)) {
                actionAttempts.put(e2.getKey(), actionStatus);
            }
            if (e2.getKey() != ActionType.ATTACK || !actionAttempts.getOrDefault((Object)ActionType.ATTACK, false).booleanValue() || actionAttempts.getOrDefault((Object)ActionType.USE, true).booleanValue() || (using = this.actions.get((Object)ActionType.USE)) == null) continue;
            using.retry(this, ActionType.USE);
        }
        float f = vel = this.sneaking ? 0.3f : 1.0f;
        if (this.forward != 0.0f || this.player instanceof EntityPlayerMPFake) {
            this.player.f_20902_ = this.forward * vel;
        }
        if (this.strafing != 0.0f || this.player instanceof EntityPlayerMPFake) {
            this.player.f_20900_ = this.strafing * vel;
        }
    }

    static HitResult getTarget(ServerPlayer player) {
        double reach = player.f_8941_.m_9295_() ? 5.0 : 4.5;
        return Tracer.rayTrace((Entity)player, 1.0f, reach, false);
    }

    private void dropItemFromSlot(int slot, boolean dropAll) {
        Inventory inv = this.player.m_150109_();
        if (!inv.m_8020_(slot).m_41619_()) {
            this.player.m_7197_(inv.m_7407_(slot, dropAll ? inv.m_8020_(slot).m_41613_() : 1), false, true);
        }
    }

    public void drop(int selectedSlot, boolean dropAll) {
        Inventory inv = this.player.m_150109_();
        if (selectedSlot == -2) {
            for (int i = inv.m_6643_(); i >= 0; --i) {
                this.dropItemFromSlot(i, dropAll);
            }
        } else {
            if (selectedSlot == -1) {
                selectedSlot = inv.f_35977_;
            }
            this.dropItemFromSlot(selectedSlot, dropAll);
        }
    }

    public void setSlot(int slot) {
        this.player.m_150109_().f_35977_ = slot - 1;
        this.player.f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(slot - 1));
    }

    public static class Action {
        public boolean done = false;
        public final int limit;
        public final int interval;
        public final int offset;
        private int count;
        private int next;
        private final boolean isContinuous;

        private Action(int limit, int interval, int offset, boolean continuous) {
            this.limit = limit;
            this.interval = interval;
            this.offset = offset;
            this.next = interval + offset;
            this.isContinuous = continuous;
        }

        public static Action once() {
            return new Action(1, 1, 0, false);
        }

        public static Action continuous() {
            return new Action(-1, 1, 0, true);
        }

        public static Action interval(int interval) {
            return new Action(-1, interval, 0, false);
        }

        public static Action interval(int interval, int offset) {
            return new Action(-1, interval, offset, false);
        }

        Boolean tick(EntityPlayerActionPack actionPack, ActionType type) {
            --this.next;
            Boolean cancel = null;
            if (this.next <= 0) {
                if (!(this.interval != 1 || this.isContinuous || type.preventSpectator && actionPack.player.m_5833_())) {
                    type.inactiveTick(actionPack.player, this);
                }
                if (!type.preventSpectator || !actionPack.player.m_5833_()) {
                    cancel = type.execute(actionPack.player, this);
                }
                ++this.count;
                if (this.count == this.limit) {
                    type.stop(actionPack.player, null);
                    this.done = true;
                    return cancel;
                }
                this.next = this.interval;
            } else if (!type.preventSpectator || !actionPack.player.m_5833_()) {
                type.inactiveTick(actionPack.player, this);
            }
            return cancel;
        }

        void retry(EntityPlayerActionPack actionPack, ActionType type) {
            if (!type.preventSpectator || !actionPack.player.m_5833_()) {
                type.execute(actionPack.player, this);
            }
            ++this.count;
            if (this.count == this.limit) {
                type.stop(actionPack.player, null);
                this.done = true;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ActionType {
        USE(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                if (ap.itemUseCooldown > 0) {
                    --ap.itemUseCooldown;
                    return true;
                }
                if (player.m_6117_()) {
                    return true;
                }
                HitResult hit = EntityPlayerActionPack.getTarget(player);
                for (InteractionHand hand : InteractionHand.values()) {
                    switch (hit.m_6662_()) {
                        case BLOCK: {
                            InteractionResult result;
                            player.m_9243_();
                            ServerLevel world = player.m_183503_();
                            BlockHitResult blockHit = (BlockHitResult)hit;
                            BlockPos pos = blockHit.m_82425_();
                            Direction side = blockHit.m_82434_();
                            if (pos.m_123342_() >= player.m_183503_().m_151558_() - (side == Direction.UP ? 1 : 0) || !world.m_7966_((Player)player, pos) || !(result = player.f_8941_.m_7179_(player, (Level)world, player.m_21120_(hand), hand, blockHit)).m_19077_()) break;
                            if (result.m_19080_()) {
                                player.m_6674_(hand);
                            }
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                        case ENTITY: {
                            player.m_9243_();
                            EntityHitResult entityHit = (EntityHitResult)hit;
                            Entity entity = entityHit.m_82443_();
                            boolean handWasEmpty = player.m_21120_(hand).m_41619_();
                            boolean itemFrameEmpty = entity instanceof ItemFrame && ((ItemFrame)entity).m_31822_().m_41619_();
                            Vec3 relativeHitPos = entityHit.m_82450_().m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                            if (entity.m_7111_((Player)player, relativeHitPos, hand).m_19077_()) {
                                ap.itemUseCooldown = 3;
                                return true;
                            }
                            if (!player.m_36157_(entity, hand).m_19077_() || handWasEmpty && itemFrameEmpty) break;
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                    }
                    ItemStack handItem = player.m_21120_(hand);
                    if (!player.f_8941_.m_6261_(player, (Level)player.m_183503_(), handItem, hand).m_19077_()) continue;
                    ap.itemUseCooldown = 3;
                    return true;
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                ap.itemUseCooldown = 0;
                player.m_21253_();
            }
        }
        ,
        ATTACK(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                HitResult hit = EntityPlayerActionPack.getTarget(player);
                switch (hit.m_6662_()) {
                    case ENTITY: {
                        EntityHitResult entityHit = (EntityHitResult)hit;
                        if (!action.isContinuous) {
                            player.m_5706_(entityHit.m_82443_());
                            player.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        player.m_36334_();
                        player.m_9243_();
                        return true;
                    }
                    case BLOCK: {
                        EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                        if (!action.isContinuous && player.f_8941_.m_9295_()) {
                            ap.blockHitDelay = 0;
                        }
                        if (ap.blockHitDelay > 0) {
                            --ap.blockHitDelay;
                            return false;
                        }
                        BlockHitResult blockHit = (BlockHitResult)hit;
                        BlockPos pos = blockHit.m_82425_();
                        Direction side = blockHit.m_82434_();
                        if (player.m_36187_(player.f_19853_, pos, player.f_8941_.m_9290_())) {
                            return false;
                        }
                        if (ap.currentBlock != null && player.f_19853_.m_8055_(ap.currentBlock).m_60795_()) {
                            ap.currentBlock = null;
                            return false;
                        }
                        BlockState state = player.f_19853_.m_8055_(pos);
                        boolean blockBroken = false;
                        if (player.f_8941_.m_9290_().m_46408_()) {
                            player.f_8941_.m_7391_(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side, player.m_183503_().m_151558_());
                            ap.blockHitDelay = 5;
                            blockBroken = true;
                        } else if (ap.currentBlock == null || !ap.currentBlock.equals((Object)pos)) {
                            boolean notAir;
                            if (ap.currentBlock != null) {
                                player.f_8941_.m_7391_(ap.currentBlock, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, side, player.m_183503_().m_151558_());
                            }
                            player.f_8941_.m_7391_(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side, player.m_183503_().m_151558_());
                            boolean bl = notAir = !state.m_60795_();
                            if (notAir && ap.curBlockDamageMP == 0.0f) {
                                state.m_60686_(player.f_19853_, pos, (Player)player);
                            }
                            if (notAir && state.m_60625_((Player)player, (BlockGetter)player.f_19853_, pos) >= 1.0f) {
                                ap.currentBlock = null;
                                blockBroken = true;
                            } else {
                                ap.currentBlock = pos;
                                ap.curBlockDamageMP = 0.0f;
                            }
                        } else {
                            ap.curBlockDamageMP += state.m_60625_((Player)player, (BlockGetter)player.f_19853_, pos);
                            if (ap.curBlockDamageMP >= 1.0f) {
                                player.f_8941_.m_7391_(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, side, player.m_183503_().m_151558_());
                                ap.currentBlock = null;
                                ap.blockHitDelay = 5;
                                blockBroken = true;
                            }
                            player.f_19853_.m_6801_(-1, pos, (int)(ap.curBlockDamageMP * 10.0f));
                        }
                        player.m_9243_();
                        player.m_6674_(InteractionHand.MAIN_HAND);
                        return blockBroken;
                    }
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                if (ap.currentBlock == null) {
                    return;
                }
                player.f_19853_.m_6801_(-1, ap.currentBlock, -1);
                player.f_8941_.m_7391_(ap.currentBlock, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.DOWN, player.m_183503_().m_151558_());
                ap.currentBlock = null;
            }
        }
        ,
        JUMP(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                if (action.limit == 1) {
                    if (player.m_20096_()) {
                        player.m_6135_();
                    }
                } else {
                    player.m_6862_(true);
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                player.m_6862_(false);
            }
        }
        ,
        DROP_ITEM(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.m_9243_();
                player.m_182294_(false);
                return false;
            }
        }
        ,
        DROP_STACK(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.m_9243_();
                player.m_182294_(true);
                return false;
            }
        }
        ,
        SWAP_HANDS(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.m_9243_();
                ItemStack itemStack_1 = player.m_21120_(InteractionHand.OFF_HAND);
                player.m_21008_(InteractionHand.OFF_HAND, player.m_21120_(InteractionHand.MAIN_HAND));
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack_1);
                return false;
            }
        };

        public final boolean preventSpectator;

        private ActionType(boolean preventSpectator) {
            this.preventSpectator = preventSpectator;
        }

        void start(ServerPlayer player, Action action) {
        }

        abstract boolean execute(ServerPlayer var1, Action var2);

        void inactiveTick(ServerPlayer player, Action action) {
        }

        void stop(ServerPlayer player, Action action) {
            this.inactiveTick(player, action);
        }
    }
}

