/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.api.menu.control;

import dev.dubhe.curtain.api.Function;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class Button {
    private boolean init = false;
    private boolean flag;
    private final Item onItem;
    private final Item offItem;
    private final int itemCount;
    private final Component onText;
    private final Component offText;
    CompoundTag compoundTag = new CompoundTag();
    private final List<Function> turnOnFunctions = new ArrayList<Function>();
    private final List<Function> turnOffFunctions = new ArrayList<Function>();

    public Button() {
        this(true, Items.f_42127_, Items.f_42263_);
    }

    public Button(boolean defaultState) {
        this(defaultState, Items.f_42127_, Items.f_42263_);
    }

    public Button(boolean defaultState, int itemCount) {
        this(defaultState, Items.f_42127_, Items.f_42263_, itemCount);
    }

    public Button(boolean defaultState, int itemCount, Component onText, Component offText) {
        this(defaultState, Items.f_42127_, Items.f_42263_, itemCount, onText, offText);
    }

    public Button(boolean defaultState, Component onText, Component offText) {
        this(defaultState, Items.f_42127_, Items.f_42263_, 1, onText, offText);
    }

    public Button(boolean defaultState, String key) {
        this(defaultState, Items.f_42127_, Items.f_42263_, 1, (Component)TranslationHelper.translate(key, ChatFormatting.GREEN, Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false)), new Object[]{"on"}), (Component)TranslationHelper.translate(key, ChatFormatting.RED, Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false)), new Object[]{"off"}));
    }

    public Button(boolean defaultState, Item onItem, Item offItem) {
        this(defaultState, onItem, offItem, 1);
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount) {
        this(defaultState, onItem, offItem, itemCount, (Component)TranslationHelper.translate("on", ChatFormatting.GREEN, Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false)), new Object[0]), (Component)TranslationHelper.translate("off", ChatFormatting.RED, Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false)), new Object[0]));
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount, Component onText, Component offText) {
        this.flag = defaultState;
        this.onText = onText;
        this.offText = offText;
        this.onItem = onItem;
        this.offItem = offItem;
        this.itemCount = itemCount;
        this.compoundTag.m_128379_("CurtainGUIItem", true);
    }

    public void checkButton(Container container, int slot) {
        ItemStack item;
        ItemStack onItemStack = new ItemStack((ItemLike)this.onItem, this.itemCount);
        onItemStack.m_41751_(this.compoundTag.m_6426_());
        onItemStack.m_41714_(this.onText);
        ItemStack offItemStack = new ItemStack((ItemLike)this.offItem, this.itemCount);
        offItemStack.m_41751_(this.compoundTag.m_6426_());
        offItemStack.m_41714_(this.offText);
        if (!this.init) {
            this.updateButton(container, slot, onItemStack, offItemStack);
            this.init = true;
        }
        if ((item = container.m_8020_(slot)).m_41619_()) {
            boolean bl = this.flag = !this.flag;
            if (this.flag) {
                this.runTurnOnFunction();
            } else {
                this.runTurnOffFunction();
            }
        }
        this.updateButton(container, slot, onItemStack, offItemStack);
    }

    public void updateButton(Container container, int slot, ItemStack onItemStack, ItemStack offItemStack) {
        if (!(container.m_8020_(slot).m_150930_(onItemStack.m_41720_()) || container.m_8020_(slot).m_150930_(offItemStack.m_41720_()) || container.m_8020_(slot).m_41619_())) {
            return;
        }
        if (this.flag) {
            container.m_6836_(slot, onItemStack);
        } else {
            container.m_6836_(slot, offItemStack);
        }
    }

    public void addTurnOnFunction(Function function) {
        this.turnOnFunctions.add(function);
    }

    public void addTurnOffFunction(Function function) {
        this.turnOffFunctions.add(function);
    }

    public void turnOnWithoutFunction() {
        this.flag = true;
    }

    public void turnOffWithoutFunction() {
        this.flag = false;
    }

    public void turnOn() {
        this.flag = true;
        this.runTurnOnFunction();
    }

    public void turnOff() {
        this.flag = false;
        this.runTurnOffFunction();
    }

    public void runTurnOnFunction() {
        for (Function turnOnFunction : this.turnOnFunctions) {
            turnOnFunction.accept();
        }
    }

    public void runTurnOffFunction() {
        for (Function turnOffFunction : this.turnOffFunctions) {
            turnOffFunction.accept();
        }
    }

    public boolean getFlag() {
        return this.flag;
    }
}

