/*
 * Decompiled with CFR 0.152.
 */
package net.frostysauce.cobblemonupdatedenhanced.util;

import com.mojang.bridge.game.GameVersion;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DownloadingRepositorySource
implements RepositorySource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File packDir;
    private final ReentrantLock downloadLock = new ReentrantLock();
    @Nullable
    private CompletableFuture<?> currentDownload;
    @Nullable
    private Pack pack;

    public DownloadingRepositorySource(File file) {
        this.packDir = file;
    }

    public void m_7686_(@NotNull Consumer<Pack> packList, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Pack.PackConstructor constructor) {
        if (this.pack != null) {
            packList.accept(this.pack);
        }
    }

    public void downloadAndSelectResourcePack(URI packURL) {
        try {
            File destination = new File(this.packDir, "resources.zip");
            CompletableFuture<File> completablefuture = this.downloadFile(packURL, destination);
            this.currentDownload = ((CompletableFuture)completablefuture.thenCompose(this::setPack)).exceptionallyCompose(error -> {
                LOGGER.error("Failed to download pack", error);
                return this.clearPack().thenAcceptAsync(ignored -> {
                    LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)error.getMessage(), (Object)destination);
                    DownloadingRepositorySource.deleteQuietly(destination);
                });
            });
            this.currentDownload.get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            LOGGER.error("Failed to download resource pack", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<File> downloadFile(URI url, File destinationPath) {
        this.downloadLock.lock();
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(url).timeout(Duration.ofSeconds(20L)).header("X-Minecraft-Username", Minecraft.m_91087_().m_91094_().m_92546_()).header("X-Minecraft-UUID", Minecraft.m_91087_().m_91094_().m_92545_()).header("X-Minecraft-Version", SharedConstants.m_183709_().getName()).header("X-Minecraft-Version-ID", SharedConstants.m_183709_().getId()).header("X-Minecraft-Pack-Format", String.valueOf(PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_()))).header("User-Agent", "Minecraft Java/" + SharedConstants.m_183709_().getName()).GET().build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(response -> {
                if (response.statusCode() != 200) {
                    throw new RuntimeException("Server returned HTTP response code: " + response.statusCode());
                }
                try {
                    Files.copy((InputStream)response.body(), destinationPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return destinationPath;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save file to " + destinationPath, e);
                }
            });
            return completionStage;
        }
        finally {
            this.downloadLock.unlock();
        }
    }

    private static void deleteQuietly(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to delete file {}", (Object)file, (Object)ioexception);
        }
    }

    public CompletableFuture<Void> clearPack() {
        this.downloadLock.lock();
        try {
            if (this.currentDownload != null) {
                this.currentDownload.cancel(true);
            }
            this.currentDownload = null;
            if (this.pack == null) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            this.pack = null;
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.downloadLock.unlock();
        }
    }

    public CompletableFuture<Void> setPack(File resourcePackFile) {
        PackMetadataSection packmetadatasection;
        try (FilePackResources filepackresources = new FilePackResources(resourcePackFile);){
            packmetadatasection = (PackMetadataSection)filepackresources.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
        }
        catch (IOException ioexception) {
            return Util.m_137498_((Throwable)new IOException(String.format(Locale.ROOT, "Invalid resourcepack at %s", resourcePackFile), ioexception));
        }
        LOGGER.info("Applying pack {}", (Object)resourcePackFile);
        this.pack = new Pack("server", true, () -> new FilePackResources(resourcePackFile), (Component)Component.m_237115_((String)"resourcePack.server.name"), packmetadatasection.m_10373_(), PackCompatibility.m_143885_((PackMetadataSection)packmetadatasection, (PackType)PackType.CLIENT_RESOURCES), Pack.Position.TOP, true, PackSource.f_10530_);
        return CompletableFuture.completedFuture(null);
    }
}

