/*
 * Decompiled with CFR 0.152.
 */
package net.frostysauce.cobblemonupdatedenhanced.network;

import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.function.Supplier;
import net.frostysauce.cobblemonupdatedenhanced.CobblemonUpdatedEnhanced;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="cobblemonupdatedenhanced")
public class ServerReconnect {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel HELLO = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("convoy", "hello"), () -> "1", client -> true, server -> true);
    public static final SimpleChannel RECONNECT = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("convoy", "reconnect"), () -> "1", client -> true, server -> true);
    public static boolean reconnect = false;
    public static InetSocketAddress reconnectData = null;

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        CobblemonUpdatedEnhanced.LOGGER.info("Sending convoy identifier to server on login");
        HELLO.sendToServer((Object)PROTOCOL_VERSION);
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        try {
            if (event.getConnection() == null) {
                CobblemonUpdatedEnhanced.LOGGER.info("Debug disconnect: no connection");
                return;
            }
            if (event.getConnection().m_129539_() != null) {
                String reason = event.getConnection().m_129539_().getString();
                if (!reconnect && reason.contains("Please Reconnect")) {
                    CobblemonUpdatedEnhanced.LOGGER.info("Reconnecting based on disconnect reason");
                    reconnect = true;
                }
            }
            if (reconnect) {
                CobblemonUpdatedEnhanced.LOGGER.info("Reconnecting to server");
                if (event.getConnection().m_129523_() instanceof InetSocketAddress) {
                    reconnectData = (InetSocketAddress)event.getConnection().m_129523_();
                    reconnect = false;
                } else {
                    CobblemonUpdatedEnhanced.LOGGER.info("Debug disconnect: prior connect was not an InetSocketAddress");
                }
            } else {
                reconnectData = null;
            }
            CobblemonUpdatedEnhanced.LOGGER.info("Debug disconnect: {}", (Object)event.getConnection().m_129523_());
            CobblemonUpdatedEnhanced.LOGGER.info("Debug disconnect: {}", (Object)event.getConnection().m_129539_().getString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onScreenChange(ScreenEvent.Opening event) {
        if (event.getNewScreen() instanceof DisconnectedScreen && reconnectData != null) {
            ServerAddress connect = new ServerAddress(reconnectData.getHostString(), reconnectData.getPort());
            reconnectData = null;
            ConnectScreen.m_169267_((Screen)new TitleScreen(), (Minecraft)Minecraft.m_91087_(), (ServerAddress)connect, null);
            event.setCanceled(true);
        }
    }

    public static void registerPackets() {
        HELLO.registerMessage(0, String.class, ServerReconnect::encodeString, ServerReconnect::decodeString, (id, ctx) -> {}, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        RECONNECT.registerMessage(0, Boolean.TYPE, ServerReconnect::encodeBoolean, ServerReconnect::decodeBoolean, (id, ctx) -> {}, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void recieveReconnectPacket(Boolean reconnect, Supplier<NetworkEvent.Context> ctx) {
        CobblemonUpdatedEnhanced.LOGGER.info("Server has set reconnect mode to {}", (Object)reconnect);
        ServerReconnect.reconnect = reconnect;
    }

    private static void encodeString(String string, FriendlyByteBuf buf) {
        buf.m_130070_(string);
    }

    private static String decodeString(FriendlyByteBuf buf) {
        return buf.m_130277_();
    }

    private static void encodeBoolean(Boolean bool, FriendlyByteBuf buf) {
        buf.writeBoolean(bool != null ? bool : false);
    }

    private static Boolean decodeBoolean(FriendlyByteBuf buf) {
        return buf.readByte() > 0;
    }
}

