/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.world;

import com.github.dragoni7.silentcompat.networking.Networking;
import com.github.dragoni7.silentcompat.networking.PacketVolatileExplosionParticles;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class VolatileExplosion
extends Explosion {
    private final Player player;
    private final Entity attacked;
    private final Level level;
    private final float radius;
    private final double x;
    private final double y;
    private final double z;

    public VolatileExplosion(Player player, Entity entity, DamageSource source, ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius) {
        super(player.f_19853_, entity, source, damageCalculator, x, y, z, radius, false, Explosion.BlockInteraction.NONE);
        this.player = player;
        this.attacked = entity;
        this.level = player.f_19853_;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void m_46061_() {
        this.level.m_220400_(this.attacked, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.attacked, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || entity instanceof Player || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = VolatileExplosion.m_46064_((Vec3)vec3, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 6.0 * (double)f2 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
        }
    }

    public void m_46075_(boolean particles) {
        this.level.m_6263_(null, this.x, this.y, this.z, SoundEvents.f_12411_, SoundSource.NEUTRAL, 10.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (this.player instanceof ServerPlayer) {
            Networking.sendToClient(new PacketVolatileExplosionParticles(this.attacked.m_19879_()), (ServerPlayer)this.player);
        }
    }
}

