/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.trait;

import com.github.dragoni7.silentcompat.SilentCompat;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public class OnHitEffect
extends SimpleTrait {
    public static final SimpleTrait.Serializer<OnHitEffect> SERIALIZER = new SimpleTrait.Serializer(SilentCompat.getId("on_hit_effect"), OnHitEffect::new, OnHitEffect::readJson, OnHitEffect::read, OnHitEffect::write);
    private MobEffect effect;
    private int duration;
    private int chance;

    public OnHitEffect(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        if (this.effect != null && target.m_217043_().m_188503_(this.chance) % this.chance == 0) {
            if (target.m_21023_(this.effect)) {
                return super.onAttackEntity(context, target, baseValue);
            }
            target.m_7292_(new MobEffectInstance(this.effect, this.duration, context.getTraitLevel() - 1));
        }
        return super.onAttackEntity(context, target, baseValue);
    }

    private static void readJson(OnHitEffect trait, JsonObject json) {
        MobEffect mob_effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effect")));
        if (mob_effect != null) {
            trait.effect = mob_effect;
        }
        trait.duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)0);
        trait.chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)0);
    }

    private static void read(OnHitEffect trait, FriendlyByteBuf buffer) {
        MobEffect mob_effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.m_130281_());
        if (mob_effect == null) {
            mob_effect = MobEffects.f_19597_;
        }
        trait.effect = mob_effect;
        trait.duration = buffer.m_130242_();
        trait.chance = buffer.m_130242_();
    }

    private static void write(OnHitEffect trait, FriendlyByteBuf buffer) {
        buffer.m_130085_(OnHitEffect.fromEffect(trait.effect));
        buffer.m_130130_(trait.duration);
        buffer.m_130130_(trait.chance);
    }

    private static ResourceLocation fromEffect(MobEffect effect) {
        ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
        return key != null ? key : ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19597_);
    }

    public Collection<String> getExtraWikiLines() {
        Collection ret = super.getExtraWikiLines();
        if (this.effect != null) {
            ret.add(this.chance + "% chance to apply effect on hit.");
        }
        return ret;
    }
}

