/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.trait;

import com.github.dragoni7.silentcompat.core.registry.SilentCompatEffects;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatSoundEvents;
import com.github.dragoni7.silentcompat.networking.Networking;
import com.github.dragoni7.silentcompat.networking.PacketJoltChain;
import com.github.dragoni7.silentcompat.networking.PacketJoltParticles;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public class JoltHitTrait
extends SimpleTrait {
    public static final SimpleTrait.Serializer<JoltHitTrait> SERIALIZER = new SimpleTrait.Serializer(new ResourceLocation("silentcompat", "jolt_hit"), JoltHitTrait::new);

    public JoltHitTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        Player player = context.getPlayer();
        if (player.m_21023_((MobEffect)SilentCompatEffects.AMPLIFIED.get())) {
            int joltHit = context.getTraitLevel();
            Mob nearestEntity = (Mob)target.f_19853_.m_45963_(Mob.class, TargetingConditions.m_148352_(), target, target.m_20185_(), target.m_20186_(), target.m_20189_(), new AABB(target.m_20183_()).m_82377_(10.0, 10.0, 10.0));
            if (!player.f_19853_.f_46443_) {
                target.f_19853_.m_5594_(null, target.m_20183_(), (SoundEvent)SilentCompatSoundEvents.ELECTRIC_ZAP.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                if (player instanceof ServerPlayer) {
                    Networking.sendToClient(new PacketJoltParticles(target.m_19879_()), (ServerPlayer)player);
                    if (nearestEntity != null) {
                        Networking.sendToClient(new PacketJoltChain(target.m_20182_(), nearestEntity.m_20182_()), (ServerPlayer)player);
                    }
                }
            }
            if (nearestEntity != null) {
                nearestEntity.m_6469_(DamageSource.f_19306_, (float)joltHit + baseValue / 2.0f);
            }
            player.m_21195_((MobEffect)SilentCompatEffects.AMPLIFIED.get());
            return baseValue + (float)joltHit + baseValue / 4.0f;
        }
        return baseValue;
    }

    public Collection<String> getExtraWikiLines() {
        Collection ret = super.getExtraWikiLines();
        ret.add("Consumes amplified, dealing bonus damage and chaining to a nearby entity.");
        return ret;
    }
}

