/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.trait;

import com.github.dragoni7.silentcompat.SilentCompat;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.lib.util.NameUtils;

public class ItemDropTrait
extends SimpleTrait {
    public static final SimpleTrait.Serializer<ItemDropTrait> SERIALIZER = new SimpleTrait.Serializer(SilentCompat.getId("item_drop"), ItemDropTrait::new, ItemDropTrait::readJson, ItemDropTrait::read, ItemDropTrait::write);
    private Item dropItem;
    private int chance;

    public ItemDropTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        Level level;
        Player player = context.getPlayer();
        if (player != null && (level = player.m_9236_()).m_213780_().m_188503_(this.chance) % this.chance == 0 && !level.f_46443_) {
            Vec3 pos = player.m_20182_();
            RandomSource random = level.m_213780_();
            double d0 = Mth.m_216283_((RandomSource)random, (float)-0.2f, (float)0.2f);
            double d1 = Mth.m_216283_((RandomSource)random, (float)0.3f, (float)0.5f);
            double d2 = Mth.m_216283_((RandomSource)random, (float)-0.2f, (float)0.2f);
            level.m_7967_((Entity)new ItemEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), new ItemStack((ItemLike)this.dropItem), d0, d1, d2));
        }
        return super.onDurabilityDamage(context, damageTaken);
    }

    private static void readJson(ItemDropTrait trait, JsonObject json) {
        Item dropItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item")));
        if (dropItem != null) {
            trait.dropItem = dropItem;
        }
        trait.chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)0);
    }

    private static void read(ItemDropTrait trait, FriendlyByteBuf buffer) {
        trait.dropItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
        trait.chance = buffer.m_130242_();
    }

    private static void write(ItemDropTrait trait, FriendlyByteBuf buffer) {
        buffer.m_130085_(NameUtils.fromItem((ItemLike)trait.dropItem));
        buffer.m_130130_(trait.chance);
    }

    public Collection<String> getExtraWikiLines() {
        Collection ret = super.getExtraWikiLines();
        if (this.dropItem != null) {
            ret.add("Chance to drop" + NameUtils.fromItem((ItemLike)this.dropItem) + " on durability loss with 1 out of" + this.chance + "% chance");
        }
        return ret;
    }
}

