/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.networking;

import com.github.dragoni7.silentcompat.core.registry.SilentCompatParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PacketJoltChain {
    private Vec3 origin;
    private Vec3 target;

    public PacketJoltChain(Vec3 origin, Vec3 target) {
        this.origin = origin;
        this.target = target;
    }

    public PacketJoltChain(FriendlyByteBuf buf) {
        this.origin = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.target = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.origin.f_82479_);
        buf.writeDouble(this.origin.f_82480_);
        buf.writeDouble(this.origin.f_82481_);
        buf.writeDouble(this.target.f_82479_);
        buf.writeDouble(this.target.f_82480_);
        buf.writeDouble(this.target.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isClient()) {
            context.get().enqueueWork(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                ClientLevel level = minecraft.f_91073_;
                double distance = this.origin.m_82554_(this.target);
                if (level != null) {
                    for (double d = 0.0; d < distance; d += 0.25) {
                        double fdist = d / distance;
                        level.m_7106_((ParticleOptions)SilentCompatParticles.JOLT_CHAIN.get(), Mth.m_14139_((double)fdist, (double)this.origin.f_82479_, (double)this.target.f_82479_), Mth.m_14139_((double)fdist, (double)this.origin.f_82480_, (double)this.target.f_82480_) + 1.0, Mth.m_14139_((double)fdist, (double)this.origin.f_82481_, (double)this.target.f_82481_), 0.0, 0.0, 0.0);
                    }
                }
            });
            return true;
        }
        return false;
    }
}

