/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public abstract class AbstractPacketDisplayHitParticle {
    private int hitEntity;

    public AbstractPacketDisplayHitParticle(int hitEntity) {
        this.hitEntity = hitEntity;
    }

    public AbstractPacketDisplayHitParticle(FriendlyByteBuf buf) {
        this.hitEntity = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.hitEntity);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                player = this.getClientPlayer();
            }
            if (player != null && player.f_19853_ != null) {
                Entity entity = player.f_19853_.m_6815_(this.hitEntity);
                Vec3 pos = entity.m_20182_();
                if (entity instanceof LivingEntity) {
                    double y = entity.m_20191_().m_82376_() / 2.0 + entity.f_19853_.f_46441_.m_188500_();
                    this.addParticles(entity.f_19853_, pos, y);
                }
            }
        });
        return true;
    }

    protected abstract void addParticles(Level var1, Vec3 var2, double var3);

    @OnlyIn(value=Dist.CLIENT)
    private Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

