/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.data;

import com.github.dragoni7.silentcompat.core.registry.MaterialRegistry;
import com.github.dragoni7.silentcompat.core.registry.MaterialSet;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatEffects;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;

public class lang
extends LanguageProvider {
    public lang(DataGenerator gen, String locale) {
        super(gen, "silentcompat", locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.silentcompat", "SilentCompat");
        for (MaterialSet set : MaterialRegistry.MATERIAL_SETS.values()) {
            String name = set.name.replace('_', ' ');
            name = StringUtils.capitaliseAllWords((String)name);
            this.translateMaterialSet(set, name);
        }
        this.add((Block)MaterialRegistry.ARCMETAL_ORE.get(), "Arc Metal Ore");
        this.add((Block)MaterialRegistry.VOIDMETAL_ORE.get(), "Void Metal Ore");
        this.add((Block)MaterialRegistry.SOLARMETAL_ORE.get(), "Solar Metal Ore");
        this.add((Block)MaterialRegistry.PLASTEEL_ORE.get(), "Plasteel Ore");
        this.add((Item)SilentCompatItems.RAW_ARCMETAL.get(), "Raw Arcmetal");
        this.add((Item)SilentCompatItems.RAW_SOLARMETAL.get(), "Raw Solarmetal");
        this.add((Item)SilentCompatItems.RAW_VOIDMETAL.get(), "Raw Voidmetal");
        this.add((Item)SilentCompatItems.RAW_PLASTEEL.get(), "Raw Plasteel");
        this.add((Item)SilentCompatItems.OUTBACK_LEATHER.get(), "Outback Leather");
        this.add((Item)SilentCompatItems.CHOCOLATECHIP.get(), "Chocolate Chip");
        this.add((Item)SilentCompatItems.CRYSTALLINE_ALLOY.get(), "Crystalline Alloy");
        this.add((MobEffect)SilentCompatEffects.AMPLIFIED.get(), "Amplified");
        this.add((MobEffect)SilentCompatEffects.DEVOURING.get(), "Devouring");
        this.add((MobEffect)SilentCompatEffects.RESTORATION.get(), "Restoration");
        this.add((MobEffect)SilentCompatEffects.VOLATILE.get(), "Volatile");
        this.add((MobEffect)SilentCompatEffects.SCORCH.get(), "Scorch");
        this.add("trait.silentcompat.diurnal", "Diurnal");
        this.add("trait.silentcompat.diurnal.desc", "Deal increased damage during the day. Gear slowly repairs during the day");
        this.add("trait.silentcompat.nocturnal", "Nocturnal");
        this.add("trait.silentcompat.nocturnal.desc", "Deal increased damage at night. Gear slowly repairs at night");
        this.add("trait.silentcompat.decay", "Decay");
        this.add("trait.silentcompat.decay.desc", "Applies Decay to targets (Requires: Dreamland)");
        this.add("trait.silentcompat.ender_flu", "Ender Flu");
        this.add("trait.silentcompat.ender_flu.desc", "Infects the target with Ender Flu (Requires: Alexs Mobs)");
        this.add("trait.silentcompat.dodging", "Dodging");
        this.add("trait.silentcompat.dodging.desc", "Grants a chance to avoid damage. Requires full armor set. Does not protect against projectiles and armor ignoring damage");
        this.add("trait.silentcompat.chocolate_chipping", "Chocolate Chipping");
        this.add("trait.silentcompat.chocolate_chipping.desc", "Chance to drop a chocolate chip on durability loss");
        this.add("trait.silentcompat.fleetfooted", "Fleet-Footed");
        this.add("trait.silentcompat.fleetfooted.desc", "Increases speed while jumping and sprinting on-hit (Requires: Alexs Mobs)");
        this.add("trait.silentcompat.freezing", "Freezing");
        this.add("trait.silentcompat.freezing.desc", "Attacks build up freezing on target. At max freeze, damage is dealth over time. Just like stepping in powdered snow. (Requires: Ars Nouveau)");
        this.add("trait.silentcompat.featherweight", "Featherweight");
        this.add("trait.silentcompat.featherweight.desc", "Targets take additional knockback when hit. (Requires: Undergarden)");
        this.add("trait.silentcompat.vorpal", "Vorpal");
        this.add("trait.silentcompat.vorpal.desc", "Deal more damage to targets with over 200 hearts");
        this.add("trait.silentcompat.hungering_strike", "Hungering Strike");
        this.add("trait.silentcompat.hungering_strike.desc", "Deal more damage while under half hunger");
        this.add("trait.silentcompat.soul_steal", "Soul Steal");
        this.add("trait.silentcompat.soul_steal.desc", "Chance to gain life steal on hit. (Requires: Alexs Mobs)");
        this.add("trait.silentcompat.lucky_break", "Lucky Break");
        this.add("trait.silentcompat.lucky_break.desc", "Chance to gain random potion effect when hit. Effected by luck");
        this.add("trait.silentcompat.retaliating_blast", "Retaliating Blast");
        this.add("trait.silentcompat.retaliating_blast.desc", "Attacks or being attacked have a chance to apply a delayed explosion on the target (Requires: Ars Nouveau)");
        this.add("trait.silentcompat.knockout", "Knockout");
        this.add("trait.silentcompat.knockout.desc", "Chance to inflict a heavy knockback to targets");
        this.add("trait.silentcompat.abyssal_synergy", "Abyssal Synergy");
        this.add("trait.silentcompat.abyssal_synergy.desc", "Tools deal more damage the deeper you are. Less durability loss the deeper you are.");
        this.add("trait.silentcompat.vigorous", "Vigorous");
        this.add("trait.silentcompat.vigorous.desc", "Deal more damage while at full health");
        this.add("trait.silentcompat.unstable_magic", "Unstable Magic");
        this.add("trait.silentcompat.unstable_magic.desc", "Somtimes gain a random positive magic effect or apply random negative magic effect to targets. (Requires: Ars Nouveau)");
        this.add("trait.silentcompat.gooey", "Gooey");
        this.add("trait.silentcompat.gooey.desc", "Attacks have a chance to apply scintling goo under the target's feet. (Requires: Undergarden");
        this.add("trait.silentcompat.knightly", "Knightly");
        this.add("trait.silentcompat.knightly.desc", "Attacks do extra damage to armored targets");
        this.add("trait.silentcompat.fire_react", "Fire React");
        this.add("trait.silentcompat.fire_react.desc", "Sets attackers on fire");
        this.add("trait.silentcompat.neptunes_might", "Neptune's Might");
        this.add("trait.silentcompat.neptunes_might.desc", "Does more damage to targets while in water");
        this.add("trait.silentcompat.cold", "Cold");
        this.add("trait.silentcompat.cold.desc", "Chills attackers. (Requires: Twilight Forest");
        this.add("trait.silentcompat.emu_dodge", "Emu Dodge");
        this.add("trait.silentcompat.emu_dodge.desc", "Grants a chance to avoid projectile damage. Requires full armor set");
        this.add("trait.silentcompat.jolt_hit", "Jolt Hit");
        this.add("trait.silentcompat.jolt_hit.desc", "Consumes amplified, dealing bonus damage and chaining to a nearby entity.");
        this.add("trait.silentcompat.amplifying", "Amplifying");
        this.add("trait.silentcompat.amplifying.desc", "Getting a kill has a chance to grant the amplified effect. Requires full set");
        this.add("trait.silentcompat.blinding", "Blinding");
        this.add("trait.silentcompat.blinding.desc", "Consumes amplified on tool swing, launching a projectile that blinds and slows targets. Damage is equal to 3 times trait level.");
        this.add("trait.silentcompat.purifying", "Purifying");
        this.add("trait.silentcompat.purifying.desc", "Rare chance to remove harmful effects when hit. Requires full set");
        this.add("trait.silentcompat.devouring", "Devouring");
        this.add("trait.silentcompat.devouring.desc", "Getting a kill has a chance to grant the devouring effect. Requires full set.");
        this.add("trait.silentcompat.umbral_blast", "Umbral Blast");
        this.add("trait.silentcompat.umbral_blast.desc", "Consumes devouring on tool swing, launching a projectile that weakens, damages, and knocks back targets. Damage is equal to 3 times the trait level.");
        this.add("trait.silentcompat.volatile", "Volatile");
        this.add("trait.silentcompat.volatile.desc", "Consumes devouring, applying the volatile effect on the target.");
        this.add("trait.silentcompat.restoration", "Restoration");
        this.add("trait.silentcompat.restoration.desc", "Getting a kill has a chance to grant the restoration effect. Requires full set.");
        this.add("trait.silentcompat.scorching", "Scorching");
        this.add("trait.silentcompat.scorching.desc", "Consumes restoration, applying the scorch effect to the target hit.");
        this.add("trait.silentcompat.sunspot", "Sun Spot");
        this.add("trait.silentcompat.sunspot.desc", "Consumes restoration. Standing in fire puts it out, healing a large chunk of health and granting strength.");
        this.add("trait.silentcompat.lava_vision", "Lava Vision");
        this.add("trait.silentcompat.lava_vision.desc", "Provides the Lava Vision effect while in lava. (Requires: Alexs Mobs)");
        this.add("trait.silentcompat.adrenaline", "Adrenaline");
        this.add("trait.silentcompat.adrenaline.desc", "Briefly applies adrenaline rush when at low health. (Requires: Biomancy)");
        this.add("trait.silentcompat.corrosive", "Corrosive");
        this.add("trait.silentcompat.corrosive.desc", "Briefly applies corrosive to hit targets. (Requires: Biomancy)");
        this.add("trait.silentcompat.mana_repair", "Mana Repair");
        this.add("trait.silentcompat.mana_repair.desc", "Uses 20 + ( 40 per trait level) mana to repair gear. (Requires: Botania)");
        this.add("trait.silentcompat.mana_burst", "Mana Burst");
        this.add("trait.silentcompat.mana_burst.desc", "The Mana Burst is identical to that of a default, unenchanted Terra Blade. Uses 100 mana per burst.");
        this.add("trait.silentcompat.pixie", "Pixilate");
        this.add("trait.silentcompat.pixie.desc", "Pixies may spawn when you are damaged.");
        this.add("trait.silentcompat.gaia_burst", "Gaia Burst");
        this.add("trait.silentcompat.gaia_burst.desc", "The Mana Burst is identical to that of a default, unenchanted Mana Stealing Blade.");
        this.add("trait.silentcompat.alf_burst", "Alf Burst");
        this.add("trait.silentcompat.alf_burst.desc", "The Mana Burst is identical to that of a default, unenchanted Alf Blade.");
        this.add("trait.silentcompat.wither_skull", "Wither Skull");
        this.add("trait.silentcompat.wither_skull.desc", "Summons a wither skull projectile on swing, costing durability.");
        this.add("effect.silentcompat.amplified.description", "Increases speed. Allows certain traits such as Jolt Hit to proc.");
        this.add("effect.silentcompat.devouring.description", "Grants absorption hearts on kills. Has a cap. Allows certain traits such as volitile to proc.");
        this.add("effect.silentcompat.restoration.description", "Steadily restores hp over time. Allows certain traits such as scorch to proc.");
        this.add("effect.silentcompat.volatile.description", "Causes explosions when hit.");
        this.add("effect.silentcompat.scorch.description", "Sets the target on fire. When the effect ends, the target explodes, spreading scorch to nearby mobs.");
    }

    private void translateMaterialSet(MaterialSet set, String name) {
        this.add((Item)set.ingot.get(), name + " Ingot");
        this.add((Item)set.nugget.get(), name + " Nugget");
        this.add((Block)set.block.get(), name + " Block");
        this.add("material.silentcompat." + set.name, name);
    }
}

