/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.data;

import com.github.dragoni7.silentcompat.core.registry.MaterialRegistry;
import com.github.dragoni7.silentcompat.core.registry.MaterialSet;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class SilentCompatItemModels
extends ItemModelProvider {
    public SilentCompatItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        for (MaterialSet set : MaterialRegistry.MATERIAL_SETS.values()) {
            this.registerMaterialSetItemModels(set);
        }
        this.blockItemModel(SilentCompatItems.ARCMETAL_ORE_ITEM, "block/arcmetal_ore");
        this.blockItemModel(SilentCompatItems.VOIDMETAL_ORE_ITEM, "block/voidmetal_ore");
        this.blockItemModel(SilentCompatItems.SOLARMETAL_ORE_ITEM, "block/solarmetal_ore");
        this.blockItemModel(SilentCompatItems.PLASTEEL_ORE_ITEM, "block/plasteel_ore");
        this.singleTextureItemModel(SilentCompatItems.RAW_PLASTEEL, "item/raw_plasteel");
        this.singleTextureItemModel(SilentCompatItems.RAW_ARCMETAL, "item/raw_arcmetal");
        this.singleTextureItemModel(SilentCompatItems.RAW_VOIDMETAL, "item/raw_voidmetal");
        this.singleTextureItemModel(SilentCompatItems.RAW_SOLARMETAL, "item/raw_solarmetal");
        this.singleTextureItemModel(SilentCompatItems.OUTBACK_LEATHER, "item/outback_leather");
        this.singleTextureItemModel(SilentCompatItems.CHOCOLATECHIP, "item/chocolate_chip");
        this.singleTextureItemModel(SilentCompatItems.CRYSTALLINE_ALLOY, "item/crystalline_alloy");
    }

    private void registerMaterialSetItemModels(MaterialSet set) {
        this.blockItemModel(set.blockItem, "block/" + set.name + "_block");
        this.singleTextureItemModel(set.ingot, "item/" + set.name + "_ingot");
        this.singleTextureItemModel(set.nugget, "item/" + set.name + "_nugget");
    }

    private void singleTextureItemModel(RegistryObject<Item> item, String path) {
        this.singleTexture(item.getId().m_135815_(), new ResourceLocation("item/handheld"), "layer0", new ResourceLocation("silentcompat", path));
    }

    private void blockItemModel(RegistryObject<Item> item, String path) {
        this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("silentcompat", path));
    }
}

