/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.blazekrew.variant16x.Variant16x;
import net.blazekrew.variant16x.data.VariantCapeData;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapeRenderer {
    private static final Map<UUID, VariantCapeData> CAPE_DATA_MAP = new HashMap<UUID, VariantCapeData>();
    private static final Map<String, ResourceLocation> CAPE_TYPES = new ImmutableMap.Builder().put((Object)"creator", (Object)new ResourceLocation("variant16x", "textures/entity/cape/creator.png")).put((Object)"amethyst", (Object)new ResourceLocation("variant16x", "textures/entity/cape/developer.png")).put((Object)"emerald", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor3.png")).put((Object)"diamond", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor2.png")).put((Object)"gold", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor.png")).put((Object)"copper", (Object)new ResourceLocation("variant16x", "textures/entity/cape/translator.png")).build();
    private static final Gson CAPES_JSON = new Gson();
    private static final String CAPES_JSON_LOCATION = "https://raw.githubusercontent.com/BKthousand/update16x/master/variant16x/capes.json";
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36";
    private static final String BKTHOUSAND_UUID = "3e1e75c8-4c46-4559-a595-75670e6b2621";
    private static final ResourceLocation BKTHOUSAND_CAPE = CAPE_TYPES.get("creator");

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderCapes(RenderPlayerEvent.Post renderEvent) {
        Player player = renderEvent.getPlayer();
        UUID uuid = Player.m_36198_((GameProfile)player.m_36316_());
        if (CAPE_DATA_MAP.containsKey(uuid)) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            Map textures = clientPlayer.f_108546_.f_105299_;
            if (clientPlayer.m_108555_() && (clientPlayer.m_108561_() == null || ConfigRegistry.isEnabled(ConfigRegistry.OVERRIDE_CAPES) && !ConfigRegistry.getList(ConfigRegistry.OVERRIDE_CAPES_BLACKLIST).contains(uuid.toString())) && !uuid.equals(UUID.fromString(BKTHOUSAND_UUID))) {
                textures.put(MinecraftProfileTexture.Type.CAPE, CapeRenderer.getCapeType(uuid));
            } else if (clientPlayer.m_108555_() && uuid.equals(UUID.fromString(BKTHOUSAND_UUID))) {
                textures.put(MinecraftProfileTexture.Type.CAPE, BKTHOUSAND_CAPE);
            }
        }
    }

    private static ResourceLocation getCapeType(UUID uuid) {
        VariantCapeData capeData = CAPE_DATA_MAP.get(uuid);
        if (capeData.getCapeTypeOverride() != null) {
            return CAPE_TYPES.get(capeData.getCapeTypeOverride());
        }
        if (capeData.isDeveloper()) {
            return CAPE_TYPES.get("amethyst");
        }
        if (capeData.getDonorData() != null) {
            if (capeData.getDonorData().isDonor() && VariantCapeData.VariantDonorData.isValidDonorCape(capeData.getDonorData().getDonorLevel())) {
                return CAPE_TYPES.get(capeData.getDonorData().getDonorLevel());
            }
        } else if (capeData.isTranslator()) {
            return CAPE_TYPES.get("copper");
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerCapes() {
        CapeRenderer.getData(CAPES_JSON_LOCATION, Util.m_137578_()).thenAcceptAsync(stream -> {
            if (stream == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)stream);){
                JsonObject object = GsonHelper.m_13859_((Reader)reader);
                for (Map.Entry entry : object.entrySet()) {
                    CAPE_DATA_MAP.put(UUID.fromString((String)entry.getKey()), (VariantCapeData)CAPES_JSON.fromJson((JsonElement)entry.getValue(), VariantCapeData.class));
                }
            }
            catch (Exception exception) {
                Variant16x.VARIANT16X_LOGGER.error("Unable to load Cape Data.", (Throwable)exception);
            }
        }, (Executor)Minecraft.m_91087_());
    }

    private static CompletableFuture<InputStream> getData(String url, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            InputStream inputStream;
            block8: {
                InputStream stream = CapeRenderer.getUrl(url);
                try {
                    inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Variant16x.VARIANT16X_LOGGER.error("Unable to read data from '" + url + "'.", (Throwable)exception);
                        return null;
                    }
                }
                stream.close();
            }
            return inputStream;
        }, executor);
    }

    private static InputStream getUrl(String url) throws URISyntaxException, IOException {
        HttpURLConnection connection = (HttpURLConnection)new URI(url).toURL().openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        InputStream stream = connection.getInputStream();
        if (connection.getResponseCode() != 200) {
            if (stream != null) {
                stream.close();
            } else if (connection.getErrorStream() != null) {
                connection.getErrorStream().close();
            }
            throw new IOException("Unable to connect to '" + url + "'. " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return stream;
    }
}

