/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Features;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.blockplacers.BlockPlacer;
import net.minecraft.world.level.levelgen.feature.blockplacers.SimpleBlockPlacer;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.ConfiguredDecorator;

public class FeatureRegistry {
    public static ConfiguredFeature<?, ?> INFESTED_ANDESITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_ANDESITE, false);
    public static ConfiguredFeature<?, ?> INFESTED_DIORITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_DIORITE, false);
    public static ConfiguredFeature<?, ?> INFESTED_GRANITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_GRANITE, false);
    public static ConfiguredFeature<?, ?> INFESTED_TUFF_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_TUFF, true);
    public static ConfiguredFeature<?, ?> PAEONIA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.PAEONIA);
    public static ConfiguredFeature<?, ?> ROSE_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.ROSE);
    public static ConfiguredFeature<?, ?> SYRINGA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SYRINGA);
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SMALL_SUNFLOWER);
    public static ConfiguredFeature<HugeFungusConfiguration, ?> CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> WARPED_FUNGUS_PLANTED_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> WARPED_FUNGUS_PLANTED_STAIRS_CONFIG;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> CRIMSON_FUNGUS_PLANTED_VERTICAL_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> WARPED_FUNGUS_PLANTED_VERTICAL_SLAB_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_ANDESITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_DIORITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_GRANITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_TUFF_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_PATCHES_CONFIG;

    public static void registerFeatures() {
        CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.CRIMSON_NYLIUM_SLAB, false);
        WARPED_FUNGUS_PLANTED_SLAB_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.WARPED_NYLIUM_SLAB, true);
        CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.CRIMSON_NYLIUM_STAIRS, false);
        WARPED_FUNGUS_PLANTED_STAIRS_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.WARPED_NYLIUM_STAIRS, true);
        INFESTED_ANDESITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_ANDESITE_CONFIG, 2);
        INFESTED_DIORITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_DIORITE_CONFIG, 2);
        INFESTED_GRANITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_GRANITE_CONFIG, 2);
        INFESTED_TUFF_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_TUFF_CONFIG, 4);
        RARE_PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 1);
        PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 8);
        RARE_ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 1);
        ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 8);
        RARE_SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 1);
        SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 8);
        SMALL_SUNFLOWER_PATCHES_CONFIG = FeatureRegistry.registerPatch(SMALL_SUNFLOWER_CONFIG, 9);
        FeatureRegistry.register(CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG, "variant16x", "crimson_fungus_planted_slab");
        FeatureRegistry.register(WARPED_FUNGUS_PLANTED_SLAB_CONFIG, "variant16x", "warped_fungus_planted_slab");
        FeatureRegistry.register(CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG, "variant16x", "crimson_fungus_planted_stairs");
        FeatureRegistry.register(WARPED_FUNGUS_PLANTED_STAIRS_CONFIG, "variant16x", "warped_fungus_planted_stairs");
        FeatureRegistry.register(INFESTED_ANDESITE_BLOBS_CONFIG, "variant16x", "infested_andesite_blobs");
        FeatureRegistry.register(INFESTED_DIORITE_BLOBS_CONFIG, "variant16x", "infested_diorite_blobs");
        FeatureRegistry.register(INFESTED_GRANITE_BLOBS_CONFIG, "variant16x", "infested_granite_blobs");
        FeatureRegistry.register(INFESTED_TUFF_BLOBS_CONFIG, "variant16x", "infested_tuff_blobs");
        FeatureRegistry.register(RARE_PAEONIA_PATCHES_CONFIG, "variant16x", "rare_paeonia_patches");
        FeatureRegistry.register(PAEONIA_PATCHES_CONFIG, "variant16x", "paeonia_patches");
        FeatureRegistry.register(RARE_ROSE_PATCHES_CONFIG, "variant16x", "rare_rose_patches");
        FeatureRegistry.register(ROSE_PATCHES_CONFIG, "variant16x", "rose_patches");
        FeatureRegistry.register(RARE_SYRINGA_PATCHES_CONFIG, "variant16x", "rare_syringa_patches");
        FeatureRegistry.register(SYRINGA_PATCHES_CONFIG, "variant16x", "syringa_patches");
        FeatureRegistry.register(SMALL_SUNFLOWER_PATCHES_CONFIG, "variant16x", "small_sunflower_patches");
    }

    public static <FC extends FeatureConfiguration> ConfiguredFeature<?, ?> register(ConfiguredFeature<FC, ?> feature, String modId, String featureId) {
        return (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation(modId, featureId), feature);
    }

    private static ConfiguredFeature<HugeFungusConfiguration, ?> registerFungusPlanted(Block block, boolean isWarped) {
        if (isWarped) {
            return Feature.f_65743_.m_65815_((FeatureConfiguration)new HugeFungusConfiguration(block.m_49966_(), Blocks.f_50686_.m_49966_(), Blocks.f_50692_.m_49966_(), Blocks.f_50701_.m_49966_(), true));
        }
        return Feature.f_65743_.m_65815_((FeatureConfiguration)new HugeFungusConfiguration(block.m_49966_(), Blocks.f_50695_.m_49966_(), Blocks.f_50451_.m_49966_(), Blocks.f_50701_.m_49966_(), true));
    }

    private static ConfiguredFeature<?, ?> registerInfested(Block block, boolean isDeepslateReplacer) {
        if (isDeepslateReplacer) {
            return Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_161029_, block.m_49966_(), 7));
        }
        return Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_161028_, block.m_49966_(), 7));
    }

    private static ConfiguredFeature<?, ?> registerPlant(Block block) {
        return Feature.f_65763_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(block.m_49966_()), (BlockPlacer)new SimpleBlockPlacer()).m_67991_(64).m_67995_().m_68003_());
    }

    public static ConfiguredFeature<?, ?> registerBlob(ConfiguredFeature<?, ?> feature, int count) {
        return (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)feature.m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)63))).m_64152_()).m_64158_(count);
    }

    public static ConfiguredFeature<?, ?> registerPatch(ConfiguredFeature<?, ?> feature, int count) {
        return ((ConfiguredFeature)Feature.f_65755_.m_65815_((FeatureConfiguration)new SimpleRandomFeatureConfiguration((List)ImmutableList.of(() -> feature))).m_158243_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-3, (int)1), (int)0, (int)1))).m_7679_((ConfiguredDecorator)Features.Decorators.f_127090_.m_7679_(Features.Decorators.f_127091_).m_64158_(count));
    }
}

