/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.Sets;
import java.util.Set;
import net.blazekrew.variant16x.block.addon.VariantVerticalSlabBlock;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.ItemRegistry;
import net.blazekrew.variant16x.registry.StrippableRegistry;
import net.blazekrew.variant16x.registry.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventRegistry {
    private static final Set<ResourceLocation> VARIANT_SIMPLE_DUNGEON = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78742_});
    private static final Set<ResourceLocation> VARIANT_WOODLAND_MANSION = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78689_});

    @SubscribeEvent
    public static void onLootTableLoaded(LootTableLoadEvent lootEvent) {
        if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_MISCELLANEOUS) && ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_MUSIC_DISCS)) {
            if (VARIANT_SIMPLE_DUNGEON.contains(lootEvent.getName())) {
                LootPool pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemRegistry.MUSIC_DISC_DOG).m_79707_(1).m_79711_(0)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(2).m_79711_(0)).name("variant_simple_dungeon").m_79082_();
                lootEvent.getTable().addPool(pool);
            } else if (VARIANT_WOODLAND_MANSION.contains(lootEvent.getName())) {
                LootPool pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemRegistry.MUSIC_DISC_DOG).m_79707_(1).m_79711_(0)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(2).m_79711_(0)).name("variant_woodland_mansion").m_79082_();
                lootEvent.getTable().addPool(pool);
            }
        }
    }

    @SubscribeEvent
    public static void onFurnaceFueled(FurnaceFuelBurnTimeEvent furnaceEvent) {
        Item item = furnaceEvent.getItemStack().m_41720_();
        if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_SLABS, item) || TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_VERTICAL_SLABS, item)) {
            furnaceEvent.setBurnTime(50);
        } else if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_STAIRS, item) || TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_WALLS, item) || TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_PRESSURE_PLATES, item)) {
            furnaceEvent.setBurnTime(100);
        } else if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_BUTTONS, item)) {
            furnaceEvent.setBurnTime(33);
        }
    }

    @SubscribeEvent
    public static void onRightClickedBlockWithAxe(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof AxeItem) {
            Level world = event.getWorld();
            BlockPos position = event.getPos();
            Player player = event.getPlayer();
            InteractionHand hand = event.getHand();
            BlockState state = world.m_8055_(position);
            Block block = state.m_60734_();
            Block slabBlock = StrippableRegistry.SLAB_STRIPPABLES.get(block);
            Block stairsBlock = StrippableRegistry.STAIRS_STRIPPABLES.get(block);
            Block fenceBlock = StrippableRegistry.FENCE_STRIPPABLES.get(block);
            Block fenceGateBlock = StrippableRegistry.FENCE_GATE_STRIPPABLES.get(block);
            Block pressurePlateBlock = StrippableRegistry.PRESSURE_PLATE_STRIPPABLES.get(block);
            Block buttonBlock = StrippableRegistry.BUTTON_STRIPPABLES.get(block);
            Block verticalSlabBlock = StrippableRegistry.VERTICAL_SLAB_STRIPPABLES.get(block);
            if (slabBlock != null || stairsBlock != null || fenceBlock != null || fenceGateBlock != null || pressurePlateBlock != null || buttonBlock != null || verticalSlabBlock != null) {
                world.m_5594_(player, position, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6674_(hand);
                if (!world.f_46443_) {
                    if (slabBlock != null) {
                        world.m_7731_(position, (BlockState)((BlockState)slabBlock.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)state.m_61143_((Property)SlabBlock.f_56353_)))).m_61124_((Property)SlabBlock.f_56354_, (Comparable)((Boolean)state.m_61143_((Property)SlabBlock.f_56354_))), 11);
                    } else if (stairsBlock != null) {
                        world.m_7731_(position, (BlockState)((BlockState)((BlockState)((BlockState)stairsBlock.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)state.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)state.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)state.m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)state.m_61143_((Property)StairBlock.f_56844_))), 11);
                    } else if (fenceBlock != null) {
                        world.m_7731_(position, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fenceBlock.m_49966_().m_61124_((Property)CrossCollisionBlock.f_52310_, (Comparable)((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_)))).m_61124_((Property)CrossCollisionBlock.f_52309_, (Comparable)((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_)))).m_61124_((Property)CrossCollisionBlock.f_52311_, (Comparable)((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_)))).m_61124_((Property)CrossCollisionBlock.f_52313_, (Comparable)((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52313_)))).m_61124_((Property)CrossCollisionBlock.f_52312_, (Comparable)((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_))), 11);
                    } else if (fenceGateBlock != null) {
                        world.m_7731_(position, (BlockState)((BlockState)((BlockState)((BlockState)fenceGateBlock.m_49966_().m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)FenceGateBlock.f_54117_)))).m_61124_((Property)FenceGateBlock.f_53343_, (Comparable)((Boolean)state.m_61143_((Property)FenceGateBlock.f_53343_)))).m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)))).m_61124_((Property)FenceGateBlock.f_53342_, (Comparable)((Boolean)state.m_61143_((Property)FenceGateBlock.f_53342_))), 11);
                    } else if (pressurePlateBlock != null) {
                        world.m_7731_(position, (BlockState)pressurePlateBlock.m_49966_().m_61124_((Property)PressurePlateBlock.f_55249_, (Comparable)((Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_))), 11);
                    } else if (buttonBlock != null) {
                        world.m_7731_(position, (BlockState)((BlockState)((BlockState)buttonBlock.m_49966_().m_61124_((Property)ButtonBlock.f_53179_, (Comparable)((AttachFace)state.m_61143_((Property)ButtonBlock.f_53179_)))).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)ButtonBlock.f_54117_)))).m_61124_((Property)ButtonBlock.f_51045_, (Comparable)((Boolean)state.m_61143_((Property)ButtonBlock.f_51045_))), 11);
                    } else {
                        world.m_7731_(position, (BlockState)((BlockState)verticalSlabBlock.m_49966_().m_61124_(VariantVerticalSlabBlock.TYPE, (Comparable)((Object)((VariantVerticalSlabBlock.VariantVerticalSlabType)((Object)state.m_61143_(VariantVerticalSlabBlock.TYPE)))))).m_61124_((Property)VariantVerticalSlabBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)VariantVerticalSlabBlock.WATERLOGGED))), 11);
                    }
                    stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(hand));
                }
            }
        }
    }
}

