/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blazekrew.variant16x.Variant16x;
import net.blazekrew.variant16x.condition.VariantIsEnabledCondition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigRegistry {
    public static Map<String, Boolean> VARIANT16X_CONFIG_MAP = new HashMap<String, Boolean>();
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON;
    public static ForgeConfigSpec SERVER;
    public static ForgeConfigSpec.BooleanValue ENABLE_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_FENCES;
    public static ForgeConfigSpec.BooleanValue ENABLE_FENCE_GATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_MISCELLANEOUS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SANDSTONE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_STAIRS;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PRISMARINE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PURPUR_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SANDSTONE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_WALLS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_FENCES;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_FENCES;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_FENCE_GATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_BRICK_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_PRISMARINE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_PURPUR_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_SANDSTONE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BRICK_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PRISMARINE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PURPUR_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SANDSTONE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_BUTTONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WEIGHTED_PRESSURE_PLATES;
    public static ForgeConfigSpec.BooleanValue ENABLE_INFESTED_STONES;
    public static ForgeConfigSpec.BooleanValue ENABLE_SMALL_FLOWERS;
    public static ForgeConfigSpec.BooleanValue ENABLE_MUSIC_DISCS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BOATS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PAINTINGS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ADVANCEMENTS;
    public static ForgeConfigSpec.BooleanValue ENABLE_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOD_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_END_STONE_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_HONEYCOMB_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHER_BRICK_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_QUARTZ_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_STONE_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_TERRACOTTA_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_WOOL_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_AMETHYST_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_BASALT_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GLASS_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_OBSIDIAN_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CLAY_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SNOW_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_CONCRETE_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_GRAVEL_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_ICE_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_NETHERRACK_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue ENABLE_SAND_VERTICAL_SLABS;
    public static ForgeConfigSpec.BooleanValue OVERRIDE_CAPES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> OVERRIDE_CAPES_BLACKLIST;

    public static void registerConfigs(ForgeConfigSpec type, String pathName) {
        ConfigRegistry.registerFolder();
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(FMLPaths.CONFIGDIR.get().resolve(pathName).toString())).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        type.setConfig((CommentedConfig)file);
    }

    private static void registerServer(ForgeConfigSpec.Builder builder) {
        builder.comment("'Variant16x' Server Configuration File | Game Version: 1.17.1\n\n'Variant16x' Settings").push("variant16x");
        builder.comment("Cape Settings\nThese options are for a PER World/Server basis.").push("capes");
        OVERRIDE_CAPES = builder.comment("Overrides OFFICIAL Minecraft Capes with 'Variant16x's' Capes | Default: false").define("overrideCapes", false);
        OVERRIDE_CAPES_BLACKLIST = builder.comment("A list of Player UUIDs that WON'T be affected by any overrides.\nExample: overrideCapesBlacklist = [\"853c80ef-3c37-49fd-aa49-938b674adae6\", \"069a79f4-44e9-4726-a5be-fca90e38aaf5\"]").defineList("overrideCapesBlacklist", Collections.emptyList(), list -> list instanceof String);
        builder.pop();
        builder.pop();
    }

    private static void registerCommon(ForgeConfigSpec.Builder builder) {
        builder.comment("'Variant16x' Common Configuration File | Game Version: 1.17.1\n\n'Variant16x' Settings").push("variant16x");
        builder.comment("General Settings\nThese options will OVERRIDE any Custom Settings!").push("general");
        ENABLE_SLABS = builder.comment("Enables/Disables ALL Slab Variants | Default: true").define("enableSlabs", true);
        ENABLE_STAIRS = builder.comment("Enables/Disables ALL Stairs Variants").define("enableStairs", true);
        ENABLE_WALLS = builder.comment("Enables/Disables ALL Wall Variants").define("enableWalls", true);
        ENABLE_FENCES = builder.comment("Enables/Disables ALL Fence Variants").define("enableFences", true);
        ENABLE_FENCE_GATES = builder.comment("Enables/Disables ALL Fence Gate Variants").define("enableFenceGates", true);
        ENABLE_PRESSURE_PLATES = builder.comment("Enables/Disables ALL Pressure Plate Variants").define("enablePressurePlates", true);
        ENABLE_BUTTONS = builder.comment("Enables/Disables ALL Button Variants").define("enableButtons", true);
        ENABLE_MISCELLANEOUS = builder.comment("Enables/Disables ALL Miscellaneous Variants").define("enableMiscellaneous", true);
        builder.pop();
        builder.comment("Custom Settings\nThese options allow for more in-depth configuring.").push("custom");
        builder.comment("Custom Slab Settings").push("slabs");
        ENABLE_WOOD_SLABS = builder.comment("Enables/Disables Wood/Hyphae Slab Variants | Default: true").define("enableWoodSlabs", true);
        ENABLE_END_STONE_SLABS = builder.comment("Enables/Disables End Stone Slab Variants | Default: true").define("enableEndStoneSlabs", true);
        ENABLE_HONEYCOMB_SLABS = builder.comment("Enables/Disables Honeycomb Slab Variants | Default: true").define("enableHoneycombSlabs", true);
        ENABLE_NETHER_BRICK_SLABS = builder.comment("Enables/Disables Nether Brick Slab Variants | Default: true").define("enableNetherBrickSlabs", true);
        ENABLE_QUARTZ_SLABS = builder.comment("Enables/Disables Quartz Slab Variants | Default: true").define("enableQuartzSlabs", true);
        ENABLE_STONE_SLABS = builder.comment("Enables/Disables Stone/Other Slab Variants | Default: true").define("enableStoneSlabs", true);
        ENABLE_TERRACOTTA_SLABS = builder.comment("Enables/Disables Terracotta Slab Variants | Default: true").define("enableTerracottaSlabs", true);
        ENABLE_WOOL_SLABS = builder.comment("Enables/Disables Wool Slab Variants | Default: true").define("enableWoolSlabs", true);
        ENABLE_AMETHYST_SLABS = builder.comment("Enables/Disables Amethyst Slab Variants | Default: true").define("enableAmethystSlabs", true);
        ENABLE_BASALT_SLABS = builder.comment("Enables/Disables Basalt Slab Variants | Default: true").define("enableBasaltSlabs", true);
        ENABLE_GLASS_SLABS = builder.comment("Enables/Disables Glass Slab Variants | Default: true").define("enableGlassSlabs", true);
        ENABLE_OBSIDIAN_SLABS = builder.comment("Enables/Disables Obsidian Slab Variants | Default: true").define("enableObsidianSlabs", true);
        ENABLE_CLAY_SLABS = builder.comment("Enables/Disables Clay Slab Variants | Default: true").define("enableClaySlabs", true);
        ENABLE_SNOW_SLABS = builder.comment("Enables/Disables Snow Slab Variants | Default: true").define("enableSnowSlabs", true);
        ENABLE_CONCRETE_SLABS = builder.comment("Enables/Disables Concrete/Concrete Powder Slab Variants | Default: true").define("enableConcreteSlabs", true);
        ENABLE_GRAVEL_SLABS = builder.comment("Enables/Disables Gravel Slab Variants").define("enableGravelSlabs", true);
        ENABLE_ICE_SLABS = builder.comment("Enables/Disables Ice Slab Variants | Default: true").define("enableIceSlabs", true);
        ENABLE_NETHERRACK_SLABS = builder.comment("Enables/Disables Netherrack/Nylium Slab Variants | Default: true").define("enableNetherrackSlabs", true);
        ENABLE_SAND_SLABS = builder.comment("Enables/Disables Sand Slab Variants | Default: true").define("enableSandSlabs", true);
        builder.pop();
        builder.comment("Custom Stairs Settings").push("stairs");
        ENABLE_WOOD_STAIRS = builder.comment("Enables/Disables Wood/Hyphae Stairs Variants | Default: true").define("enableWoodStairs", true);
        ENABLE_END_STONE_STAIRS = builder.comment("Enables/Disables End Stone Stairs Variants | Default: true").define("enableEndStoneStairs", true);
        ENABLE_HONEYCOMB_STAIRS = builder.comment("Enables/Disables Honeycomb Stairs Variants | Default: true").define("enableHoneycombStairs", true);
        ENABLE_NETHER_BRICK_STAIRS = builder.comment("Enables/Disables Nether Brick Stairs Variants | Default: true").define("enableNetherBrickStairs", true);
        ENABLE_QUARTZ_STAIRS = builder.comment("Enables/Disables Quartz Stairs Variants | Default: true").define("enableQuartzStairs", true);
        ENABLE_SANDSTONE_STAIRS = builder.comment("Enables/Disables Sandstone Stairs Variants | Default: true").define("enableSandstoneStairs", true);
        ENABLE_STONE_STAIRS = builder.comment("Enables/Disables Stone/Other Stairs Variants | Default: true").define("enableStoneStairs", true);
        ENABLE_TERRACOTTA_STAIRS = builder.comment("Enables/Disables Terracotta Stairs Variants | Default: true").define("enableTerracottaStairs", true);
        ENABLE_WOOL_STAIRS = builder.comment("Enables/Disables Wool Stairs Variants | Default: true").define("enableWoolStairs", true);
        ENABLE_AMETHYST_STAIRS = builder.comment("Enables/Disables Amethyst Stairs Variants | Default: true").define("enableAmethystStairs", true);
        ENABLE_BASALT_STAIRS = builder.comment("Enables/Disables Basalt Stairs Variants | Default: true").define("enableBasaltStairs", true);
        ENABLE_GLASS_STAIRS = builder.comment("Enables/Disables Glass Stairs Variants | Default: true").define("enableGlassStairs", true);
        ENABLE_OBSIDIAN_STAIRS = builder.comment("Enables/Disables Obsidian Stairs Variants | Default: true").define("enableObsidianStairs", true);
        ENABLE_CLAY_STAIRS = builder.comment("Enables/Disables Clay Stairs Variants | Default: true").define("enableClayStairs", true);
        ENABLE_SNOW_STAIRS = builder.comment("Enables/Disables Snow Stairs Variants | Default: true").define("enableSnowStairs", true);
        ENABLE_CONCRETE_STAIRS = builder.comment("Enables/Disables Concrete/Concrete Powder Stairs Variants | Default: true").define("enableConcreteStairs", true);
        ENABLE_GRAVEL_STAIRS = builder.comment("Enables/Disables Gravel Stairs Variants | Default: true").define("enableGravelStairs", true);
        ENABLE_ICE_STAIRS = builder.comment("Enables/Disables Ice Stairs Variants | Default: true").define("enableIceStairs", true);
        ENABLE_NETHERRACK_STAIRS = builder.comment("Enables/Disables Netherrack/Nylium Stairs Variants | Default: true").define("enableNetherrackStairs", true);
        ENABLE_SAND_STAIRS = builder.comment("Enables/Disables Sand Stairs Variants | Default: true").define("enableSandStairs", true);
        builder.pop();
        builder.comment("Custom Wall Settings").push("walls");
        ENABLE_END_STONE_WALLS = builder.comment("Enables/Disables End Stone Wall Variants | Default: true").define("enableEndStoneWalls", true);
        ENABLE_HONEYCOMB_WALLS = builder.comment("Enables/Disables Honeycomb Wall Variants | Default: true").define("enableHoneycombWalls", true);
        ENABLE_NETHER_BRICK_WALLS = builder.comment("Enables/Disables Nether Brick Wall Variants | Default: true").define("enableNetherBrickWalls", true);
        ENABLE_PRISMARINE_WALLS = builder.comment("Enables/Disables Prismarine Wall Variants | Default: true").define("enablePrismarineWalls", true);
        ENABLE_PURPUR_WALLS = builder.comment("Enables/Disables Purpur Wall Variants | Default: true").define("enablePurpurWalls", true);
        ENABLE_QUARTZ_WALLS = builder.comment("Enables/Disables Quartz Wall Variants | Default: true").define("enableQuartzWalls", true);
        ENABLE_SANDSTONE_WALLS = builder.comment("Enables/Disables Sandstone Wall Variants | Default: true").define("enableSandstoneWalls", true);
        ENABLE_STONE_WALLS = builder.comment("Enables/Disables Stone/Other Wall Variants | Default: true").define("enableStoneWalls", true);
        ENABLE_TERRACOTTA_WALLS = builder.comment("Enables/Disables Terracotta Wall Variants | Default: true").define("enableTerracottaWalls", true);
        ENABLE_WOOL_WALLS = builder.comment("Enables/Disables Wool Wall Variants | Default: true").define("enableWoolWalls", true);
        ENABLE_AMETHYST_WALLS = builder.comment("Enables/Disables Amethyst Wall Variants | Default: true").define("enableAmethystWalls", true);
        ENABLE_BASALT_WALLS = builder.comment("Enables/Disables Basalt Wall Variants | Default: true").define("enableBasaltWalls", true);
        ENABLE_GLASS_WALLS = builder.comment("Enables/Disables Glass Wall Variants | Default: true").define("enableGlassWalls", true);
        ENABLE_OBSIDIAN_WALLS = builder.comment("Enables/Disables Obsidian Wall Variants | Default: true").define("enableObsidianWalls", true);
        ENABLE_CLAY_WALLS = builder.comment("Enables/Disables Clay Wall Variants | Default: true").define("enableClayWalls", true);
        ENABLE_SNOW_WALLS = builder.comment("Enables/Disables Snow Wall Variants | Default: true").define("enableSnowWalls", true);
        ENABLE_CONCRETE_WALLS = builder.comment("Enables/Disables Concrete/Concrete Powder Wall Variants | Default: true").define("enableConcreteWalls", true);
        ENABLE_GRAVEL_WALLS = builder.comment("Enables/Disables Gravel Wall Variants | Default: true").define("enableGravelWalls", true);
        ENABLE_ICE_WALLS = builder.comment("Enables/Disables Ice Wall Variants | Default: true").define("enableIceWalls", true);
        ENABLE_NETHERRACK_WALLS = builder.comment("Enables/Disables Netherrack/Nylium Wall Variants | Default: true").define("enableNetherrackWalls", true);
        ENABLE_SAND_WALLS = builder.comment("Enables/Disables Sand Wall Variants | Default: true").define("enableSandWalls", true);
        builder.pop();
        builder.comment("Custom Fence Settings").push("fences");
        ENABLE_WOOD_FENCES = builder.comment("Enables/Disables Wood/Hyphae Fence Variants | Default: true").define("enableWoodFences", true);
        ENABLE_NETHER_BRICK_FENCES = builder.comment("Enables/Disables Nether Brick Fence Variants | Default: true").define("enableNetherBrickFences", true);
        builder.pop();
        builder.comment("Custom Fence Gate Settings").push("fenceGates");
        ENABLE_WOOD_FENCE_GATES = builder.comment("Enables/Disables Wood/Hyphae Fence Gate Variants | Default: true").define("enableWoodFenceGates", true);
        builder.pop();
        builder.comment("Custom Pressure Plate Settings").push("pressurePlates");
        ENABLE_WOOD_PRESSURE_PLATES = builder.comment("Enables/Disables Wood/Hyphae Pressure Plate Variants | Default: true").define("enableWoodPressurePlates", true);
        ENABLE_BRICK_PRESSURE_PLATES = builder.comment("Enables/Disables Brick Pressure Plate Variants | Default: true").define("enableBrickPressurePlates", true);
        ENABLE_END_STONE_PRESSURE_PLATES = builder.comment("Enables/Disables End Stone Pressure Plate Variants").define("enableEndStonePressurePlates", true);
        ENABLE_HONEYCOMB_PRESSURE_PLATES = builder.comment("Enables/Disables Honeycomb Pressure Plate Variants | Default: true").define("enableHoneycombPressurePlates", true);
        ENABLE_NETHER_BRICK_PRESSURE_PLATES = builder.comment("Enables/Disables Nether Brick Pressure Plate Variants | Default: true").define("enableNetherBrickPressurePlates", true);
        ENABLE_PRISMARINE_PRESSURE_PLATES = builder.comment("Enables/Disables Prismarine Pressure Plate Variants | Default: true").define("enablePrismarinePressurePlates", true);
        ENABLE_PURPUR_PRESSURE_PLATES = builder.comment("Enables/Disables Purpur Pressure Plate Variants | Default: true").define("enablePurpurPressurePlates", true);
        ENABLE_QUARTZ_PRESSURE_PLATES = builder.comment("Enables/Disables Quartz Pressure Plate Variants | Default: true").define("enableQuartzPressurePlates", true);
        ENABLE_SANDSTONE_PRESSURE_PLATES = builder.comment("Enables/Disables Sandstone Pressure Plate Variants | Default: true").define("enableSandstonePressurePlates", true);
        ENABLE_STONE_PRESSURE_PLATES = builder.comment("Enables/Disables Stone/Other Pressure Plate Variants | Default: true").define("enableStonePressurePlates", true);
        ENABLE_TERRACOTTA_PRESSURE_PLATES = builder.comment("Enables/Disables Terracotta Pressure Plate Variants | Default: true").define("enableTerracottaPressurePlates", true);
        ENABLE_WOOL_PRESSURE_PLATES = builder.comment("Enables/Disables Wool Pressure Plate Variants | Default: true").define("enableWoolPressurePlates", true);
        ENABLE_AMETHYST_PRESSURE_PLATES = builder.comment("Enables/Disables Amethyst Pressure Plate Variants | Default: true").define("enableAmethystPressurePlates", true);
        ENABLE_BASALT_PRESSURE_PLATES = builder.comment("Enables/Disables Basalt Pressure Plate Variants | Default: true").define("enableBasaltPressurePlates", true);
        ENABLE_GLASS_PRESSURE_PLATES = builder.comment("Enables/Disables Glass Pressure Plate Variants | Default: true").define("enableGlassPressurePlates", true);
        ENABLE_OBSIDIAN_PRESSURE_PLATES = builder.comment("Enables/Disables Obsidian Pressure Plate Variants | Default: true").define("enableObsidianPressurePlates", true);
        ENABLE_CLAY_PRESSURE_PLATES = builder.comment("Enables/Disables Clay Pressure Plate Variants | Default: true").define("enableClayPressurePlates", true);
        ENABLE_SNOW_PRESSURE_PLATES = builder.comment("Enables/Disables Snow Pressure Plate Variants | Default: true").define("enableSnowPressurePlates", true);
        ENABLE_CONCRETE_PRESSURE_PLATES = builder.comment("Enables/Disables Concrete/Concrete Powder Pressure Plate Variants | Default: true").define("enableConcretePressurePlates", true);
        ENABLE_GRAVEL_PRESSURE_PLATES = builder.comment("Enables/Disables Gravel Pressure Plate Variants | Default: true").define("enableGravelPressurePlates", true);
        ENABLE_ICE_PRESSURE_PLATES = builder.comment("Enables/Disables Ice Pressure Plate Variants | Default: true").define("enableIcePressurePlates", true);
        ENABLE_NETHERRACK_PRESSURE_PLATES = builder.comment("Enables/Disables Netherrack/Nylium Pressure Plate Variants | Default: true").define("enableNetherrackPressurePlates", true);
        ENABLE_SAND_PRESSURE_PLATES = builder.comment("Enables/Disables Sand Pressure Plate Variants | Default: true").define("enableSandPressurePlates", true);
        builder.pop();
        builder.comment("Custom Button Settings").push("buttons");
        ENABLE_WOOD_BUTTONS = builder.comment("Enables/Disables Wood/Hyphae Button Variants | Default: true").define("enableWoodButtons", true);
        ENABLE_BRICK_BUTTONS = builder.comment("Enables/Disables Brick Button Variants | Default: true").define("enableBrickButtons", true);
        ENABLE_END_STONE_BUTTONS = builder.comment("Enables/Disables End Stone Button Variants | Default: true").define("enableEndStoneButtons", true);
        ENABLE_HONEYCOMB_BUTTONS = builder.comment("Enables/Disables Honeycomb Button Variants | Default: true").define("enableHoneycombButtons", true);
        ENABLE_NETHER_BRICK_BUTTONS = builder.comment("Enables/Disables Nether Brick Button Variants | Default: true").define("enableNetherBrickButtons", true);
        ENABLE_PRISMARINE_BUTTONS = builder.comment("Enables/Disables Prismarine Button Variants | Default: true").define("enablePrismarineButtons", true);
        ENABLE_PURPUR_BUTTONS = builder.comment("Enables/Disables Purpur Button Variants | Default: true").define("enablePurpurButtons", true);
        ENABLE_QUARTZ_BUTTONS = builder.comment("Enables/Disables Quartz Button Variants | Default: true").define("enableQuartzButtons", true);
        ENABLE_SANDSTONE_BUTTONS = builder.comment("Enables/Disables Sandstone Button Variants | Default: true").define("enableSandstoneButtons", true);
        ENABLE_STONE_BUTTONS = builder.comment("Enables/Disables Stone/Other Button Variants | Default: true").define("enableStoneButtons", true);
        ENABLE_TERRACOTTA_BUTTONS = builder.comment("Enables/Disables Terracotta Button Variants | Default: true").define("enableTerracottaButtons", true);
        ENABLE_WOOL_BUTTONS = builder.comment("Enables/Disables Wool Button Variants | Default: true").define("enableWoolButtons", true);
        ENABLE_AMETHYST_BUTTONS = builder.comment("Enables/Disables Amethyst Button Variants | Default: true").define("enableAmethystButtons", true);
        ENABLE_BASALT_BUTTONS = builder.comment("Enables/Disables Basalt Button Variants | Default: true").define("enableBasaltButtons", true);
        ENABLE_GLASS_BUTTONS = builder.comment("Enables/Disables Glass Button Variants | Default: true").define("enableGlassButtons", true);
        ENABLE_OBSIDIAN_BUTTONS = builder.comment("Enables/Disables Obsidian Button Variants | Default: true").define("enableObsidianButtons", true);
        ENABLE_CLAY_BUTTONS = builder.comment("Enables/Disables Clay Button Variants | Default: true").define("enableClayButtons", true);
        ENABLE_SNOW_BUTTONS = builder.comment("Enables/Disables Snow Button Variants | Default: true").define("enableSnowButtons", true);
        ENABLE_CONCRETE_BUTTONS = builder.comment("Enables/Disables Concrete/Concrete Powder Button Variants | Default: true").define("enableConcreteButtons", true);
        ENABLE_GRAVEL_BUTTONS = builder.comment("Enables/Disables Gravel Button Variants | Default: true").define("enableGravelButtons", true);
        ENABLE_ICE_BUTTONS = builder.comment("Enables/Disables Ice Button Variants | Default: true").define("enableIceButtons", true);
        ENABLE_NETHERRACK_BUTTONS = builder.comment("Enables/Disables Netherrack/Nylium Button Variants | Default: true").define("enableNetherrackButtons", true);
        ENABLE_SAND_BUTTONS = builder.comment("Enables/Disables Sand Button Variants | Default: true").define("enableSandButtons", true);
        builder.pop();
        builder.comment("Custom Miscellaneous Settings").push("miscellaneous");
        ENABLE_WEIGHTED_PRESSURE_PLATES = builder.comment("Enables/Disables Weighted Pressure Plate Variants | Default: true").define("enableWeightedPressurePlates", true);
        ENABLE_INFESTED_STONES = builder.comment("Enables/Disables Infested Stone Variants | Default: true").define("enableInfestedStones", true);
        ENABLE_SMALL_FLOWERS = builder.comment("Enables/Disables Flower Variants | Default: true").define("enableSmallFlowers", true);
        ENABLE_MUSIC_DISCS = builder.comment("Enables/Disables Music Disc Variants | Default: true").define("enableMusicDiscs", true);
        ENABLE_BOATS = builder.comment("Enables/Disables Boat Variants | Default: true").define("enableBoats", true);
        ENABLE_PAINTINGS = builder.comment("Enables/Disables Painting Variants | Default: true").define("enablePaintings", true);
        ENABLE_ADVANCEMENTS = builder.comment("Enables/Disables Advancement Variants | Default: true").define("enableAdvancements", true);
        builder.pop();
        builder.pop();
        builder.pop();
    }

    public static void registerConfigIdsAndValues(Map<String, Boolean> map) {
        ConfigRegistry.registerConfigId(map, ENABLE_SLABS, "enable_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_STAIRS, "enable_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_WALLS, "enable_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_FENCES, "enable_fences");
        ConfigRegistry.registerConfigId(map, ENABLE_FENCE_GATES, "enable_fence_gates");
        ConfigRegistry.registerConfigId(map, ENABLE_PRESSURE_PLATES, "enable_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_BUTTONS, "enable_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_MISCELLANEOUS, "enable_miscellaneous");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_SLABS, "enable_wood_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_END_STONE_SLABS, "enable_end_stone_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_HONEYCOMB_SLABS, "enable_honeycomb_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_SLABS, "enable_nether_brick_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_QUARTZ_SLABS, "enable_quartz_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_STONE_SLABS, "enable_stone_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_TERRACOTTA_SLABS, "enable_terracotta_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOL_SLABS, "enable_wool_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_AMETHYST_SLABS, "enable_amethyst_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_BASALT_SLABS, "enable_basalt_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_GLASS_SLABS, "enable_glass_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_OBSIDIAN_SLABS, "enable_obsidian_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_CLAY_SLABS, "enable_clay_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_SNOW_SLABS, "enable_snow_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_CONCRETE_SLABS, "enable_concrete_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_GRAVEL_SLABS, "enable_gravel_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_ICE_SLABS, "enable_ice_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHERRACK_SLABS, "enable_netherrack_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_SAND_SLABS, "enable_sand_slabs");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_STAIRS, "enable_wood_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_END_STONE_STAIRS, "enable_end_stone_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_HONEYCOMB_STAIRS, "enable_honeycomb_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_STAIRS, "enable_nether_brick_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_QUARTZ_STAIRS, "enable_quartz_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_SANDSTONE_STAIRS, "enable_sandstone_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_STONE_STAIRS, "enable_stone_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_TERRACOTTA_STAIRS, "enable_terracotta_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOL_STAIRS, "enable_wool_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_AMETHYST_STAIRS, "enable_amethyst_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_BASALT_STAIRS, "enable_basalt_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_GLASS_STAIRS, "enable_glass_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_OBSIDIAN_STAIRS, "enable_obsidian_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_CLAY_STAIRS, "enable_clay_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_SNOW_STAIRS, "enable_snow_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_CONCRETE_STAIRS, "enable_concrete_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_GRAVEL_STAIRS, "enable_gravel_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_ICE_STAIRS, "enable_ice_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHERRACK_STAIRS, "enable_netherrack_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_SAND_STAIRS, "enable_sand_stairs");
        ConfigRegistry.registerConfigId(map, ENABLE_END_STONE_WALLS, "enable_end_stone_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_HONEYCOMB_WALLS, "enable_honeycomb_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_WALLS, "enable_nether_brick_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_PRISMARINE_WALLS, "enable_prismarine_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_PURPUR_WALLS, "enable_purpur_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_QUARTZ_WALLS, "enable_quartz_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_SANDSTONE_WALLS, "enable_sandstone_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_STONE_WALLS, "enable_stone_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_TERRACOTTA_WALLS, "enable_terracotta_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOL_WALLS, "enable_wool_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_AMETHYST_WALLS, "enable_amethyst_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_BASALT_WALLS, "enable_basalt_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_GLASS_WALLS, "enable_glass_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_OBSIDIAN_WALLS, "enable_obsidian_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_CLAY_WALLS, "enable_clay_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_SNOW_WALLS, "enable_snow_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_CONCRETE_WALLS, "enable_concrete_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_GRAVEL_WALLS, "enable_gravel_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_ICE_WALLS, "enable_ice_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHERRACK_WALLS, "enable_netherrack_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_SAND_WALLS, "enable_sand_walls");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_FENCES, "enable_wood_fences");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_FENCES, "enable_nether_brick_fences");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_FENCE_GATES, "enable_wood_fence_gates");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_PRESSURE_PLATES, "enable_wood_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_BRICK_PRESSURE_PLATES, "enable_brick_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_END_STONE_PRESSURE_PLATES, "enable_end_stone_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_HONEYCOMB_PRESSURE_PLATES, "enable_honeycomb_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_PRESSURE_PLATES, "enable_nether_brick_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_PRISMARINE_PRESSURE_PLATES, "enable_prismarine_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_PURPUR_PRESSURE_PLATES, "enable_purpur_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_QUARTZ_PRESSURE_PLATES, "enable_quartz_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_SANDSTONE_PRESSURE_PLATES, "enable_sandstone_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_STONE_PRESSURE_PLATES, "enable_stone_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_TERRACOTTA_PRESSURE_PLATES, "enable_terracotta_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOL_PRESSURE_PLATES, "enable_wool_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_AMETHYST_PRESSURE_PLATES, "enable_amethyst_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_BASALT_PRESSURE_PLATES, "enable_basalt_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_GLASS_PRESSURE_PLATES, "enable_glass_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_OBSIDIAN_PRESSURE_PLATES, "enable_obsidian_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_CLAY_PRESSURE_PLATES, "enable_clay_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_SNOW_PRESSURE_PLATES, "enable_snow_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_CONCRETE_PRESSURE_PLATES, "enable_concrete_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_GRAVEL_PRESSURE_PLATES, "enable_gravel_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_ICE_PRESSURE_PLATES, "enable_ice_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHERRACK_PRESSURE_PLATES, "enable_netherrack_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_SAND_PRESSURE_PLATES, "enable_sand_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOD_BUTTONS, "enable_wood_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_BRICK_BUTTONS, "enable_brick_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_END_STONE_BUTTONS, "enable_end_stone_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_HONEYCOMB_BUTTONS, "enable_honeycomb_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHER_BRICK_BUTTONS, "enable_nether_brick_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_PRISMARINE_BUTTONS, "enable_prismarine_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_PURPUR_BUTTONS, "enable_purpur_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_QUARTZ_BUTTONS, "enable_quartz_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_SANDSTONE_BUTTONS, "enable_sandstone_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_STONE_BUTTONS, "enable_stone_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_TERRACOTTA_BUTTONS, "enable_terracotta_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_WOOL_BUTTONS, "enable_wool_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_AMETHYST_BUTTONS, "enable_amethyst_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_BASALT_BUTTONS, "enable_basalt_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_GLASS_BUTTONS, "enable_glass_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_OBSIDIAN_BUTTONS, "enable_obsidian_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_CLAY_BUTTONS, "enable_clay_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_SNOW_SLABS, "enable_snow_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_CONCRETE_BUTTONS, "enable_concrete_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_GRAVEL_BUTTONS, "enable_gravel_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_ICE_BUTTONS, "enable_ice_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_NETHERRACK_BUTTONS, "enable_netherrack_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_SAND_BUTTONS, "enable_sand_buttons");
        ConfigRegistry.registerConfigId(map, ENABLE_WEIGHTED_PRESSURE_PLATES, "enable_weighted_pressure_plates");
        ConfigRegistry.registerConfigId(map, ENABLE_INFESTED_STONES, "enable_infested_stones");
        ConfigRegistry.registerConfigId(map, ENABLE_SMALL_FLOWERS, "enable_small_flowers");
        ConfigRegistry.registerConfigId(map, ENABLE_MUSIC_DISCS, "enable_music_discs");
        ConfigRegistry.registerConfigId(map, ENABLE_BOATS, "enable_boats");
        ConfigRegistry.registerConfigId(map, ENABLE_PAINTINGS, "enable_paintings");
        ConfigRegistry.registerConfigId(map, ENABLE_ADVANCEMENTS, "enable_advancements");
        ConfigRegistry.registerConfigValues("variant16x", map);
    }

    public static void registerConfigId(Map<String, Boolean> map, ForgeConfigSpec.BooleanValue configValue, String configId) {
        map.put(configId, (Boolean)configValue.get());
    }

    public static void registerConfigValues(String modId, Map<String, Boolean> map) {
        CraftingHelper.register((IConditionSerializer)new VariantIsEnabledCondition.Serializer(modId, map));
    }

    public static boolean isEnabled(ForgeConfigSpec.BooleanValue configValue) {
        return (Boolean)configValue.get();
    }

    public static List<? extends String> getList(ForgeConfigSpec.ConfigValue<List<? extends String>> configValue) {
        return (List)configValue.get();
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    private static void registerFolder() {
        Path configPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), new String[0]);
        Path folderPath = Paths.get(String.valueOf(configPath), "variant16x");
        try {
            Files.createDirectory(folderPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException exception) {
            Variant16x.VARIANT16X_LOGGER.error("Unable to find 'variant16x' directory at '" + configPath + "'.", (Throwable)exception);
        }
    }

    static {
        ConfigRegistry.registerCommon(COMMON_BUILDER);
        ConfigRegistry.registerServer(SERVER_BUILDER);
        COMMON = COMMON_BUILDER.build();
        SERVER = SERVER_BUILDER.build();
    }
}

