/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.FeatureRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeRegistry {
    @SubscribeEvent
    public static void registerBiomes(BiomeLoadingEvent biomeEvent) {
        String biomeId = biomeEvent.getName().toString();
        BiomeGenerationSettingsBuilder biomeGeneration = biomeEvent.getGeneration();
        if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_MISCELLANEOUS)) {
            if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_INFESTED_STONES) && (biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48178_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48191_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48221_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48204_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48156_)))) {
                BiomeRegistry.registerInfestedAndesiteDioriteGraniteAndTuff((BiomeGenerationSettings.Builder)biomeGeneration);
            }
            if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_SMALL_FLOWERS)) {
                if (biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48149_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48150_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48151_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48187_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48205_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48185_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48186_)) || biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48219_))) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa((BiomeGenerationSettings.Builder)biomeGeneration, false);
                }
                if (biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48179_))) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa((BiomeGenerationSettings.Builder)biomeGeneration, true);
                }
                if (biomeId.equals(BiomeRegistry.getBiomeId((ResourceKey<Biome>)Biomes.f_48176_))) {
                    BiomeRegistry.registerSmallSunflower((BiomeGenerationSettings.Builder)biomeGeneration);
                }
            }
        }
    }

    public static void registerInfestedAndesiteDioriteGraniteAndTuff(BiomeGenerationSettings.Builder biomeGeneration) {
        BiomeRegistry.registerInfestedAndesite(biomeGeneration);
        BiomeRegistry.registerInfestedDiorite(biomeGeneration);
        BiomeRegistry.registerInfestedGranite(biomeGeneration);
        BiomeRegistry.registerInfestedTuff(biomeGeneration);
    }

    public static void registerInfestedAndesite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_ANDESITE_BLOBS_CONFIG);
    }

    public static void registerInfestedDiorite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_DIORITE_BLOBS_CONFIG);
    }

    public static void registerInfestedGranite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_GRANITE_BLOBS_CONFIG);
    }

    public static void registerInfestedTuff(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_TUFF_BLOBS_CONFIG);
    }

    public static void registerPaeoniaRoseAndSyringa(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        BiomeRegistry.registerPaeonia(biomeGeneration, isCommon);
        BiomeRegistry.registerRose(biomeGeneration, isCommon);
        BiomeRegistry.registerSyringa(biomeGeneration, isCommon);
    }

    public static void registerPaeonia(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.PAEONIA_PATCHES_CONFIG);
        } else {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_PAEONIA_PATCHES_CONFIG);
        }
    }

    public static void registerRose(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.ROSE_PATCHES_CONFIG);
        } else {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_ROSE_PATCHES_CONFIG);
        }
    }

    public static void registerSyringa(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.SYRINGA_PATCHES_CONFIG);
        } else {
            biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_SYRINGA_PATCHES_CONFIG);
        }
    }

    public static void registerSmallSunflower(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, FeatureRegistry.SMALL_SUNFLOWER_PATCHES_CONFIG);
    }

    public static String getBiomeId(ResourceKey<Biome> biome) {
        return biome.m_135782_().toString();
    }
}

