/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.variant16x.block.VariantFallingSlabBlock;
import net.blazekrew.variant16x.block.VariantFallingStairBlock;
import net.blazekrew.variant16x.block.VariantFallingWallBlock;
import net.blazekrew.variant16x.block.addon.VariantFallingVerticalSlabBlock;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallingDustParticle.Provider.class})
public class ClientFallingDustParticleProviderMixin {
    @Final
    @Shadow
    private SpriteSet f_106632_;

    @Inject(method={"createParticle(Lnet/minecraft/core/particles/BlockParticleOption;Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void createParticleVariant(BlockParticleOption particleData, ClientLevel world, double x, double y, double z, double speedX, double speedY, double speedZ, CallbackInfoReturnable<Particle> info) {
        BlockState state = particleData.m_123642_();
        Block block = state.m_60734_();
        if (block instanceof VariantFallingSlabBlock || block instanceof VariantFallingStairBlock || block instanceof VariantFallingWallBlock || block instanceof VariantFallingVerticalSlabBlock) {
            BlockPos position = new BlockPos(x, y, z);
            int color = block instanceof VariantFallingSlabBlock ? ((VariantFallingSlabBlock)block).getDustColor(state, (BlockGetter)world, position) : (block instanceof VariantFallingStairBlock ? ((VariantFallingStairBlock)block).getDustColor(state, (BlockGetter)world, position) : (block instanceof VariantFallingWallBlock ? ((VariantFallingWallBlock)block).getDustColor(state, (BlockGetter)world, position) : ((VariantFallingVerticalSlabBlock)block).getDustColor(state, (BlockGetter)world, position)));
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            info.setReturnValue((Object)new FallingDustParticle(world, x, y, z, red, green, blue, this.f_106632_));
        }
    }
}

