/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.dirtlogic16x.logic.DirtLogicIsBlockLogic;
import net.blazekrew.dirtlogic16x.logic.DirtLogicIsValidLogic;
import net.blazekrew.dirtlogic16x.registry.DirtLogicTagRegistry;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.IPlantable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin
implements DirtLogicIsValidLogic,
DirtLogicIsBlockLogic {
    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=0)}, cancellable=true, remap=false)
    private void canSustainPlantCactus(BlockState state, BlockGetter world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.m_60734_();
        if (TagRegistry.isInBlockTag(DirtLogicTagRegistry.BlockTag.SAND, block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=2)}, cancellable=true, remap=false)
    private void canSustainPlantBush(BlockState state, BlockGetter world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.m_60734_();
        if (this.isValidType(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true, remap=false)
    private void canSustainPlantDesert(BlockState state, BlockGetter world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.m_60734_();
        if ((TagRegistry.isInBlockTag(DirtLogicTagRegistry.BlockTag.SAND, block) || BlockMixin.isTerracotta(block)) && !BlockMixin.isRedSand(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=9)}, cancellable=true, remap=false)
    private void canSustainPlantBeach(BlockState state, BlockGetter world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.m_60734_();
        boolean hasWater = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockState = world.m_8055_(position.m_142300_(direction));
            FluidState fluidState = world.m_6425_(position.m_142300_(direction));
            if (blockState.m_60734_() != Blocks.f_50449_ && !fluidState.m_76153_((Tag)FluidTags.f_13131_)) continue;
            hasWater = true;
        }
        if (TagRegistry.isInBlockTag(DirtLogicTagRegistry.BlockTag.SAND, block) && hasWater) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    private static boolean isRedSand(Block block) {
        return block == BlockRegistry.RED_SAND_SLAB || block == BlockRegistry.RED_SAND_STAIRS || block == BlockRegistry.RED_SAND_WALL;
    }

    private static boolean isTerracotta(Block block) {
        return block == BlockRegistry.TERRACOTTA_SLAB || block == BlockRegistry.TERRACOTTA_STAIRS || block == BlockRegistry.TERRACOTTA_WALL;
    }
}

