/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.blazekrew.variant16x.entity.VariantBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VariantBoatRenderer
extends EntityRenderer<VariantBoatEntity> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{new ResourceLocation("variant16x", "textures/entity/boat/crimson.png"), new ResourceLocation("variant16x", "textures/entity/boat/warped.png")};
    protected BoatModel model = new BoatModel(BoatModel.m_170463_().m_171564_());

    public VariantBoatRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.f_114477_ = 0.8f;
    }

    public void render(VariantBoatEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float bubbleAngle;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float hurtTime = (float)entity.m_38385_() - partialTicks;
        float damage = entity.m_38384_() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)hurtTime) * hurtTime * damage / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = entity.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.m_38352_(partialTicks), true));
        }
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        this.model.m_6973_((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexBuilder = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(matrixStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer newVertexBuilder = buffer.m_6299_(RenderType.m_110478_());
            this.model.m_102282_().m_104301_(matrixStack, newVertexBuilder, packedLight, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(VariantBoatEntity entity) {
        return BOAT_TEXTURES[entity.getBoatType2().ordinal()];
    }
}

