/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.entity;

import net.blazekrew.variant16x.registry.EntityRegistry;
import net.blazekrew.variant16x.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class VariantBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(VariantBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public VariantBoatEntity(EntityType<? extends Boat> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public VariantBoatEntity(Level world, double x, double y, double z) {
        this(EntityRegistry.BOAT, world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public VariantBoatEntity(FMLPlayMessages.SpawnEntity packet, Level world) {
        super(EntityRegistry.BOAT, world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)VariantBoatType.CRIMSON.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", this.getBoatType2().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setType(VariantBoatType.byName(compound.m_128461_("Type")));
        }
    }

    public Item m_38369_() {
        if (this.getBoatType2() == VariantBoatType.WARPED) {
            return ItemRegistry.WARPED_BOAT;
        }
        return ItemRegistry.CRIMSON_BOAT;
    }

    public void setType(VariantBoatType type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.ordinal());
    }

    public VariantBoatType getBoatType2() {
        return VariantBoatType.byId((Integer)this.f_19804_.m_135370_(TYPE));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_() && !this.m_20147_() && !this.f_19853_.f_46443_ && !this.m_146910_()) {
            this.m_6074_();
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)this.m_38369_());
            }
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos position) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getBoatType2().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_76153_((Tag)FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public static enum VariantBoatType {
        CRIMSON(Blocks.f_50655_, "crimson"),
        WARPED(Blocks.f_50656_, "warped");

        private final String name;
        private final Block block;

        private VariantBoatType(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static VariantBoatType byId(int id) {
            VariantBoatType[] boat$type = VariantBoatType.values();
            if (id < 0 || id >= boat$type.length) {
                id = 0;
            }
            return boat$type[id];
        }

        public static VariantBoatType byName(String name) {
            VariantBoatType[] boat$type;
            for (VariantBoatType type : boat$type = VariantBoatType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return boat$type[0];
        }
    }
}

