/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.condition;

import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class VariantIsEnabledCondition
implements ICondition {
    private final String modId;
    private final String configId;
    private final Boolean configValue;

    public VariantIsEnabledCondition(String modId, String configId, Boolean configValue) {
        this.modId = modId;
        this.configId = configId;
        this.configValue = configValue;
    }

    public ResourceLocation getID() {
        return new ResourceLocation(this.modId, "is_enabled");
    }

    public boolean test() {
        if (this.configValue != null) {
            return this.configValue;
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<VariantIsEnabledCondition> {
        private final String modId;
        private final Map<String, Boolean> configValues;

        public Serializer(String modId, Map<String, Boolean> configValues) {
            this.modId = modId;
            this.configValues = configValues;
        }

        public void write(JsonObject json, VariantIsEnabledCondition value) {
            json.addProperty("value", value.configId);
        }

        public VariantIsEnabledCondition read(JsonObject json) {
            String configId = GsonHelper.m_13906_((JsonObject)json, (String)"value");
            Boolean configValue = this.configValues.get(configId);
            return new VariantIsEnabledCondition(this.modId, configId, configValue);
        }

        public ResourceLocation getID() {
            return new ResourceLocation(this.modId, "is_enabled");
        }
    }
}

