/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.block.addon;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VariantVerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static EnumProperty<VariantVerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VariantVerticalSlabType.class);
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);

    public VariantVerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VariantVerticalSlabType.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state.m_61143_(TYPE) == VariantVerticalSlabType.DOUBLE ? state : (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VariantVerticalSlabType.getType(rotation.m_55954_(((VariantVerticalSlabType)((Object)state.m_61143_(VariantVerticalSlabBlock.TYPE))).direction))));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        VariantVerticalSlabType type = (VariantVerticalSlabType)((Object)state.m_61143_(TYPE));
        if (type == VariantVerticalSlabType.DOUBLE || mirror == Mirror.NONE) {
            return state;
        }
        if (mirror == Mirror.LEFT_RIGHT && type.direction.m_122434_() == Direction.Axis.Z || mirror == Mirror.FRONT_BACK && type.direction.m_122434_() == Direction.Axis.X) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VariantVerticalSlabType.getType(((VariantVerticalSlabType)((Object)state.m_61143_(VariantVerticalSlabBlock.TYPE))).direction.m_122424_())));
        }
        return state;
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != VariantVerticalSlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos position, CollisionContext context) {
        VariantVerticalSlabType type = (VariantVerticalSlabType)((Object)state.m_61143_(TYPE));
        if (type == VariantVerticalSlabType.DOUBLE) {
            return Shapes.m_83144_();
        }
        if (type == VariantVerticalSlabType.WEST) {
            return WEST_SHAPE;
        }
        if (type == VariantVerticalSlabType.EAST) {
            return EAST_SHAPE;
        }
        if (type == VariantVerticalSlabType.SOUTH) {
            return SOUTH_SHAPE;
        }
        return NORTH_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos position = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(position);
        if (state.m_60734_() == this) {
            return (BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)VariantVerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = context.m_43725_().m_6425_(position);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction direction = this.getDirectionForPlacement(context);
        VariantVerticalSlabType type = VariantVerticalSlabType.getType(direction);
        return (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)type));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        VariantVerticalSlabType type = (VariantVerticalSlabType)((Object)state.m_61143_(TYPE));
        return type != VariantVerticalSlabType.DOUBLE && stack.m_41720_() == this.m_5456_() && (context.m_7058_() && context.m_43719_() == type.direction && this.getDirectionForPlacement(context) == type.direction || !context.m_7058_() && context.m_43719_().m_122434_() != type.direction.m_122434_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos position, BlockState state, FluidState fluidState) {
        return state.m_61143_(TYPE) != VariantVerticalSlabType.DOUBLE && super.m_7361_(world, position, state, fluidState);
    }

    public boolean m_6044_(BlockGetter world, BlockPos position, BlockState state, Fluid fluid) {
        return state.m_61143_(TYPE) != VariantVerticalSlabType.DOUBLE && super.m_6044_(world, position, state, fluid);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos position, BlockPos facingPosition) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(position, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, position, facingPosition);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos position, PathComputationType pathType) {
        return pathType == PathComputationType.WATER && world.m_6425_(position).m_76153_((Tag)FluidTags.f_13131_);
    }

    protected Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        if (face.m_122434_() != Direction.Axis.Y) {
            return face;
        }
        BlockPos position = context.m_8083_();
        Vec3 result = context.m_43720_().m_82546_(new Vec3((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_())).m_82492_(0.5, 0.0, 0.5);
        double angle = Math.atan2(result.f_82479_, result.f_82481_) * -180.0 / Math.PI;
        return Direction.m_122364_((double)angle).m_122424_();
    }

    public static enum VariantVerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        public Direction direction;

        private VariantVerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.m_7912_();
            this.direction = direction;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        protected static VariantVerticalSlabType getType(Direction direction) {
            for (VariantVerticalSlabType type : VariantVerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }
    }
}

