/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.block;

import net.blazekrew.variant16x.block.VariantFallingSlabBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VariantConcretePowderSlabBlock
extends VariantFallingSlabBlock {
    private final BlockState concrete;

    public VariantConcretePowderSlabBlock(Block concreteBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.concrete = concreteBlock.m_49966_();
    }

    public void m_142216_(Level world, BlockPos position, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingEntity) {
        if (VariantConcretePowderSlabBlock.shouldSolidify((BlockGetter)world, position, hitState)) {
            world.m_7731_(position, (BlockState)((BlockState)this.concrete.m_61124_((Property)f_56353_, (Comparable)((SlabType)fallingState.m_61143_((Property)f_56353_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)fallingState.m_61143_((Property)f_56354_))), 3);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state;
        BlockPos position;
        Level world = context.m_43725_();
        if (VariantConcretePowderSlabBlock.shouldSolidify((BlockGetter)world, position = context.m_8083_(), state = world.m_8055_(position))) {
            if (state.m_60734_() == this.concrete.m_60734_()) {
                return (BlockState)((BlockState)state.m_61124_((Property)f_56353_, (Comparable)SlabType.DOUBLE)).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(false));
            }
            FluidState fluidState = world.m_6425_(position);
            BlockState blockState = (BlockState)((BlockState)this.concrete.m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
            Direction direction = context.m_43719_();
            if (direction != Direction.DOWN && (direction == Direction.UP || context.m_43720_().f_82480_ - (double)position.m_123342_() <= 0.5)) {
                return blockState;
            }
            return (BlockState)blockState.m_61124_((Property)f_56353_, (Comparable)SlabType.TOP);
        }
        return super.m_5573_(context);
    }

    private static boolean shouldSolidify(BlockGetter world, BlockPos position, BlockState state) {
        return VariantConcretePowderSlabBlock.canSolidify(state) || VariantConcretePowderSlabBlock.touchesLiquid(world, position);
    }

    private static boolean touchesLiquid(BlockGetter world, BlockPos position) {
        boolean flag = false;
        BlockPos.MutableBlockPos position$mutable = position.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState state = world.m_8055_((BlockPos)position$mutable);
            if (direction == Direction.DOWN && !VariantConcretePowderSlabBlock.canSolidify(state)) continue;
            position$mutable.m_122159_((Vec3i)position, direction);
            state = world.m_8055_((BlockPos)position$mutable);
            if (!VariantConcretePowderSlabBlock.canSolidify(state) || state.m_60783_(world, position, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos position, BlockPos facingPosition) {
        if (VariantConcretePowderSlabBlock.touchesLiquid((BlockGetter)world, position)) {
            return (BlockState)((BlockState)this.concrete.m_61124_((Property)f_56353_, (Comparable)((SlabType)state.m_61143_((Property)f_56353_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)state.m_61143_((Property)f_56354_)));
        }
        return super.m_7417_(state, facing, facingState, world, position, facingPosition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter world, BlockPos position) {
        return state.m_60780_((BlockGetter)world, (BlockPos)position).f_76396_;
    }
}

