/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.Maps;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.EventRegistry;
import net.minecraft.block.Block;

public class StrippableRegistry {
    public static void registerStrippables() {
        if (((Boolean)ConfigRegistry.ENABLE_SLABS.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_SLABS.get()).booleanValue()) {
            StrippableRegistry.registerSlab(BlockRegistry.ACACIA_WOOD_SLAB, BlockRegistry.STRIPPED_ACACIA_WOOD_SLAB);
            StrippableRegistry.registerSlab(BlockRegistry.BIRCH_WOOD_SLAB, BlockRegistry.STRIPPED_BIRCH_WOOD_SLAB);
            StrippableRegistry.registerSlab(BlockRegistry.DARK_OAK_WOOD_SLAB, BlockRegistry.STRIPPED_DARK_OAK_WOOD_SLAB);
            StrippableRegistry.registerSlab(BlockRegistry.JUNGLE_WOOD_SLAB, BlockRegistry.STRIPPED_JUNGLE_WOOD_SLAB);
            StrippableRegistry.registerSlab(BlockRegistry.OAK_WOOD_SLAB, BlockRegistry.STRIPPED_OAK_WOOD_SLAB);
            StrippableRegistry.registerSlab(BlockRegistry.SPRUCE_WOOD_SLAB, BlockRegistry.STRIPPED_SPRUCE_WOOD_SLAB);
        }
        if (((Boolean)ConfigRegistry.ENABLE_STAIRS.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_STAIRS.get()).booleanValue()) {
            StrippableRegistry.registerStairs(BlockRegistry.ACACIA_WOOD_STAIRS, BlockRegistry.STRIPPED_ACACIA_WOOD_STAIRS);
            StrippableRegistry.registerStairs(BlockRegistry.BIRCH_WOOD_STAIRS, BlockRegistry.STRIPPED_BIRCH_WOOD_STAIRS);
            StrippableRegistry.registerStairs(BlockRegistry.DARK_OAK_WOOD_STAIRS, BlockRegistry.STRIPPED_DARK_OAK_WOOD_STAIRS);
            StrippableRegistry.registerStairs(BlockRegistry.JUNGLE_WOOD_STAIRS, BlockRegistry.STRIPPED_JUNGLE_WOOD_STAIRS);
            StrippableRegistry.registerStairs(BlockRegistry.OAK_WOOD_STAIRS, BlockRegistry.STRIPPED_OAK_WOOD_STAIRS);
            StrippableRegistry.registerStairs(BlockRegistry.SPRUCE_WOOD_STAIRS, BlockRegistry.STRIPPED_SPRUCE_WOOD_STAIRS);
        }
        if (((Boolean)ConfigRegistry.ENABLE_FENCES.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_FENCES.get()).booleanValue()) {
            StrippableRegistry.registerFence(BlockRegistry.ACACIA_WOOD_FENCE, BlockRegistry.STRIPPED_ACACIA_WOOD_FENCE);
            StrippableRegistry.registerFence(BlockRegistry.BIRCH_WOOD_FENCE, BlockRegistry.STRIPPED_BIRCH_WOOD_FENCE);
            StrippableRegistry.registerFence(BlockRegistry.DARK_OAK_WOOD_FENCE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_FENCE);
            StrippableRegistry.registerFence(BlockRegistry.JUNGLE_WOOD_FENCE, BlockRegistry.STRIPPED_JUNGLE_WOOD_FENCE);
            StrippableRegistry.registerFence(BlockRegistry.OAK_WOOD_FENCE, BlockRegistry.STRIPPED_OAK_WOOD_FENCE);
            StrippableRegistry.registerFence(BlockRegistry.SPRUCE_WOOD_FENCE, BlockRegistry.STRIPPED_SPRUCE_WOOD_FENCE);
        }
        if (((Boolean)ConfigRegistry.ENABLE_FENCE_GATES.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_FENCE_GATES.get()).booleanValue()) {
            StrippableRegistry.registerFenceGate(BlockRegistry.ACACIA_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_ACACIA_WOOD_FENCE_GATE);
            StrippableRegistry.registerFenceGate(BlockRegistry.BIRCH_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_BIRCH_WOOD_FENCE_GATE);
            StrippableRegistry.registerFenceGate(BlockRegistry.DARK_OAK_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_FENCE_GATE);
            StrippableRegistry.registerFenceGate(BlockRegistry.JUNGLE_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_JUNGLE_WOOD_FENCE_GATE);
            StrippableRegistry.registerFenceGate(BlockRegistry.OAK_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_OAK_WOOD_FENCE_GATE);
            StrippableRegistry.registerFenceGate(BlockRegistry.SPRUCE_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_SPRUCE_WOOD_FENCE_GATE);
        }
        if (((Boolean)ConfigRegistry.ENABLE_PRESSURE_PLATES.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_PRESSURE_PLATES.get()).booleanValue()) {
            StrippableRegistry.registerPressurePlate(BlockRegistry.ACACIA_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_ACACIA_WOOD_PRESSURE_PLATE);
            StrippableRegistry.registerPressurePlate(BlockRegistry.BIRCH_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_BIRCH_WOOD_PRESSURE_PLATE);
            StrippableRegistry.registerPressurePlate(BlockRegistry.DARK_OAK_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_PRESSURE_PLATE);
            StrippableRegistry.registerPressurePlate(BlockRegistry.JUNGLE_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_JUNGLE_WOOD_PRESSURE_PLATE);
            StrippableRegistry.registerPressurePlate(BlockRegistry.OAK_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_OAK_WOOD_PRESSURE_PLATE);
            StrippableRegistry.registerPressurePlate(BlockRegistry.SPRUCE_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_SPRUCE_WOOD_PRESSURE_PLATE);
        }
        if (((Boolean)ConfigRegistry.ENABLE_BUTTONS.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_WOOD_BUTTONS.get()).booleanValue()) {
            StrippableRegistry.registerWoodButton(BlockRegistry.ACACIA_WOOD_BUTTON, BlockRegistry.STRIPPED_ACACIA_WOOD_BUTTON);
            StrippableRegistry.registerWoodButton(BlockRegistry.BIRCH_WOOD_BUTTON, BlockRegistry.STRIPPED_BIRCH_WOOD_BUTTON);
            StrippableRegistry.registerWoodButton(BlockRegistry.DARK_OAK_WOOD_BUTTON, BlockRegistry.STRIPPED_DARK_OAK_WOOD_BUTTON);
            StrippableRegistry.registerWoodButton(BlockRegistry.JUNGLE_WOOD_BUTTON, BlockRegistry.STRIPPED_JUNGLE_WOOD_BUTTON);
            StrippableRegistry.registerWoodButton(BlockRegistry.OAK_WOOD_BUTTON, BlockRegistry.STRIPPED_OAK_WOOD_BUTTON);
            StrippableRegistry.registerWoodButton(BlockRegistry.SPRUCE_WOOD_BUTTON, BlockRegistry.STRIPPED_SPRUCE_WOOD_BUTTON);
        }
    }

    public static void registerSlab(Block block, Block strippedBlock) {
        EventRegistry.SLAB_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.SLAB_BLOCK_STRIPPING_MAP);
        EventRegistry.SLAB_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerStairs(Block block, Block strippedBlock) {
        EventRegistry.STAIRS_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.STAIRS_BLOCK_STRIPPING_MAP);
        EventRegistry.STAIRS_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerFence(Block block, Block strippedBlock) {
        EventRegistry.FENCE_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.FENCE_BLOCK_STRIPPING_MAP);
        EventRegistry.FENCE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerFenceGate(Block block, Block strippedBlock) {
        EventRegistry.FENCE_GATE_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.FENCE_GATE_BLOCK_STRIPPING_MAP);
        EventRegistry.FENCE_GATE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerPressurePlate(Block block, Block strippedBlock) {
        EventRegistry.PRESSURE_PLATE_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.PRESSURE_PLATE_BLOCK_STRIPPING_MAP);
        EventRegistry.PRESSURE_PLATE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerWoodButton(Block block, Block strippedBlock) {
        EventRegistry.WOOD_BUTTON_BLOCK_STRIPPING_MAP = Maps.newHashMap(EventRegistry.WOOD_BUTTON_BLOCK_STRIPPING_MAP);
        EventRegistry.WOOD_BUTTON_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }
}

