/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.TagRegistry;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventRegistry {
    private static Set<ResourceLocation> VARIANT_CHESTS_SIMPLE_DUNGEON = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186422_d});
    public static Map<Block, Block> SLAB_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> STAIRS_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> FENCE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> FENCE_GATE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> PRESSURE_PLATE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> WOOD_BUTTON_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();

    @SubscribeEvent
    public static void onDungeonLootTableLoaded(LootTableLoadEvent event) {
        if (((Boolean)ConfigRegistry.ENABLE_MISCELLANEOUS.get()).booleanValue() && ((Boolean)ConfigRegistry.ENABLE_MUSIC_DISCS.get()).booleanValue() && VARIANT_CHESTS_SIMPLE_DUNGEON.contains(event.getName())) {
            LootPool pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("variant16x", "chests/inject/variant_simple_dungeon")).func_216086_a(1).func_216085_b(0)).name("simple_dungeon").func_216044_b();
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFueled(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_SLABS, item)) {
            event.setBurnTime(50);
        }
        if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_STAIRS, item) || TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_WALLS, item) || TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_PRESSURE_PLATES, item)) {
            event.setBurnTime(100);
        }
        if (TagRegistry.isInItemTag(TagRegistry.ItemTag.WOOL_BUTTONS, item)) {
            event.setBurnTime(33);
        }
    }

    @SubscribeEvent
    public static void onRightClickedWithAxe(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos position = event.getPos();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Hand hand = event.getHand();
        BlockState state = world.func_180495_p(position);
        Block block = state.func_177230_c();
        Block slabBlock = SLAB_BLOCK_STRIPPING_MAP.get(block);
        Block stairsBlock = STAIRS_BLOCK_STRIPPING_MAP.get(block);
        Block fenceBlock = FENCE_BLOCK_STRIPPING_MAP.get(block);
        Block fenceGateBlock = FENCE_GATE_BLOCK_STRIPPING_MAP.get(block);
        Block pressurePlateBlock = PRESSURE_PLATE_BLOCK_STRIPPING_MAP.get(block);
        Block woodButtonBlock = WOOD_BUTTON_BLOCK_STRIPPING_MAP.get(block);
        if (stack.func_77973_b() instanceof AxeItem && (slabBlock != null || stairsBlock != null || fenceBlock != null || fenceGateBlock != null || pressurePlateBlock != null || woodButtonBlock != null)) {
            world.func_184133_a(player, position, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!world.field_72995_K) {
                if (slabBlock != null) {
                    world.func_180501_a(position, (BlockState)((BlockState)slabBlock.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, state.func_177229_b((IProperty)SlabBlock.field_196505_a))).func_206870_a((IProperty)SlabBlock.field_204512_b, state.func_177229_b((IProperty)SlabBlock.field_204512_b)), 11);
                } else if (stairsBlock != null) {
                    world.func_180501_a(position, (BlockState)((BlockState)((BlockState)((BlockState)stairsBlock.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, state.func_177229_b((IProperty)StairsBlock.field_176309_a))).func_206870_a((IProperty)StairsBlock.field_176308_b, state.func_177229_b((IProperty)StairsBlock.field_176308_b))).func_206870_a((IProperty)StairsBlock.field_176310_M, state.func_177229_b((IProperty)StairsBlock.field_176310_M))).func_206870_a((IProperty)StairsBlock.field_204513_t, state.func_177229_b((IProperty)StairsBlock.field_204513_t)), 11);
                } else if (fenceBlock != null) {
                    world.func_180501_a(position, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fenceBlock.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, state.func_177229_b((IProperty)FourWayBlock.field_196411_b))).func_206870_a((IProperty)FourWayBlock.field_196409_a, state.func_177229_b((IProperty)FourWayBlock.field_196409_a))).func_206870_a((IProperty)FourWayBlock.field_196413_c, state.func_177229_b((IProperty)FourWayBlock.field_196413_c))).func_206870_a((IProperty)FourWayBlock.field_204514_u, state.func_177229_b((IProperty)FourWayBlock.field_204514_u))).func_206870_a((IProperty)FourWayBlock.field_196414_y, state.func_177229_b((IProperty)FourWayBlock.field_196414_y)), 11);
                } else if (fenceGateBlock != null) {
                    world.func_180501_a(position, (BlockState)((BlockState)((BlockState)((BlockState)fenceGateBlock.func_176223_P().func_206870_a((IProperty)FenceGateBlock.field_185512_D, state.func_177229_b((IProperty)FenceGateBlock.field_185512_D))).func_206870_a((IProperty)FenceGateBlock.field_176467_M, state.func_177229_b((IProperty)FenceGateBlock.field_176467_M))).func_206870_a((IProperty)FenceGateBlock.field_176466_a, state.func_177229_b((IProperty)FenceGateBlock.field_176466_a))).func_206870_a((IProperty)FenceGateBlock.field_176465_b, state.func_177229_b((IProperty)FenceGateBlock.field_176465_b)), 11);
                } else if (pressurePlateBlock != null) {
                    world.func_180501_a(position, (BlockState)pressurePlateBlock.func_176223_P().func_206870_a((IProperty)PressurePlateBlock.field_176580_a, state.func_177229_b((IProperty)PressurePlateBlock.field_176580_a)), 11);
                } else {
                    world.func_180501_a(position, (BlockState)((BlockState)((BlockState)woodButtonBlock.func_176223_P().func_206870_a((IProperty)AbstractButtonBlock.field_196366_M, state.func_177229_b((IProperty)AbstractButtonBlock.field_196366_M))).func_206870_a((IProperty)AbstractButtonBlock.field_185512_D, state.func_177229_b((IProperty)AbstractButtonBlock.field_185512_D))).func_206870_a((IProperty)AbstractButtonBlock.field_176584_b, state.func_177229_b((IProperty)AbstractButtonBlock.field_176584_b)), 11);
                }
                stack.func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(hand));
            }
        }
    }
}

