/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeRegistry {
    public static void registerBiomes() {
        if (((Boolean)ConfigRegistry.ENABLE_MISCELLANEOUS.get()).booleanValue()) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (((Boolean)ConfigRegistry.ENABLE_INFESTED_STONES.get()).booleanValue() && (biome == Biomes.field_185443_S || biome == Biomes.field_185434_af || biome == Biomes.field_76783_v || biome == Biomes.field_76770_e || biome == Biomes.field_150580_W)) {
                    BiomeRegistry.registerInfestedVariants(biome);
                }
                if (!((Boolean)ConfigRegistry.ENABLE_SMALL_FLOWERS.get()).booleanValue()) continue;
                if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_150585_R || biome == Biomes.field_185430_ab || biome == Biomes.field_76767_f || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa || biome == Biomes.field_76785_t) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa(biome, 1);
                }
                if (biome == Biomes.field_185444_T) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa(biome, 10);
                }
                if (biome != Biomes.field_185441_Q) continue;
                BiomeRegistry.registerSmallSunflower(biome, 11);
            }
        }
    }

    public static void registerInfestedVariants(Biome biome) {
        OreFeatureConfig INFESTED_ANDESITE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_ANDESITE.func_176223_P(), 7);
        OreFeatureConfig INFESTED_DIORITE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_DIORITE.func_176223_P(), 7);
        OreFeatureConfig INFESTED_GRANITE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_GRANITE.func_176223_P(), 7);
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)Feature.field_202292_al, (IFeatureConfig)new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202290_aj, Feature.field_202290_aj}, new IFeatureConfig[]{INFESTED_ANDESITE_CONFIG, INFESTED_DIORITE_CONFIG}, new float[]{0.33f, 0.33f}, Feature.field_202290_aj, (IFeatureConfig)INFESTED_GRANITE_CONFIG), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(5, 0, 0, 64)));
    }

    public static void registerPaeoniaRoseAndSyringa(Biome biome, int count) {
        BiomeRegistry.registerPaeonia(biome, count);
        BiomeRegistry.registerRose(biome, count);
        BiomeRegistry.registerSyringa(biome, count);
    }

    public static void registerPaeonia(Biome biome, int count) {
        BushConfig PAEONIA_CONFIG = new BushConfig(BlockRegistry.PAEONIA.func_176223_P());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202291_ak, (IFeatureConfig)new MultipleWithChanceRandomFeatureConfig(new Feature[]{Feature.field_202284_ad}, new IFeatureConfig[]{PAEONIA_CONFIG}, 0), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(count)));
    }

    public static void registerRose(Biome biome, int count) {
        BushConfig ROSE_CONFIG = new BushConfig(BlockRegistry.ROSE.func_176223_P());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202291_ak, (IFeatureConfig)new MultipleWithChanceRandomFeatureConfig(new Feature[]{Feature.field_202284_ad}, new IFeatureConfig[]{ROSE_CONFIG}, 0), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(count)));
    }

    public static void registerSyringa(Biome biome, int count) {
        BushConfig SYRINGA_CONFIG = new BushConfig(BlockRegistry.SYRINGA.func_176223_P());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202291_ak, (IFeatureConfig)new MultipleWithChanceRandomFeatureConfig(new Feature[]{Feature.field_202284_ad}, new IFeatureConfig[]{SYRINGA_CONFIG}, 0), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(count)));
    }

    public static void registerSmallSunflower(Biome biome, int count) {
        BushConfig SMALL_SUNFLOWER_CONFIG = new BushConfig(BlockRegistry.SMALL_SUNFLOWER.func_176223_P());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202291_ak, (IFeatureConfig)new MultipleWithChanceRandomFeatureConfig(new Feature[]{Feature.field_202284_ad}, new IFeatureConfig[]{SMALL_SUNFLOWER_CONFIG}, 0), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(count)));
    }
}

