/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.blazekrew.variant16x.Variant16x;
import net.blazekrew.variant16x.data.VariantCapeData;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapeRenderer {
    private static final Map<UUID, VariantCapeData> CAPE_DATA_MAP = new HashMap<UUID, VariantCapeData>();
    private static final Map<String, ResourceLocation> CAPE_TYPES = new ImmutableMap.Builder().put((Object)"creator", (Object)new ResourceLocation("variant16x", "textures/entity/cape/creator.png")).put((Object)"amethyst", (Object)new ResourceLocation("variant16x", "textures/entity/cape/developer.png")).put((Object)"emerald", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor3.png")).put((Object)"diamond", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor2.png")).put((Object)"gold", (Object)new ResourceLocation("variant16x", "textures/entity/cape/donor.png")).put((Object)"copper", (Object)new ResourceLocation("variant16x", "textures/entity/cape/translator.png")).build();
    private static final Gson CAPES_JSON = new Gson();
    private static final String CAPES_JSON_LOCATION = "https://raw.githubusercontent.com/BKthousand/update16x/master/variant16x/capes.json";
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36";
    private static final String BKTHOUSAND_UUID = "3e1e75c8-4c46-4559-a595-75670e6b2621";
    private static final ResourceLocation BKTHOUSAND_CAPE = CAPE_TYPES.get("creator");

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderCapes(RenderPlayerEvent.Post renderEvent) {
        PlayerEntity player = renderEvent.getPlayer();
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        if (CAPE_DATA_MAP.containsKey(uuid)) {
            AbstractClientPlayerEntity clientPlayer = (AbstractClientPlayerEntity)player;
            Map textures = clientPlayer.field_175157_a.field_187107_a;
            if (clientPlayer.func_152122_n() && (clientPlayer.func_110303_q() == null || ConfigRegistry.isEnabled(ConfigRegistry.OVERRIDE_CAPES) && !ConfigRegistry.getList(ConfigRegistry.OVERRIDE_CAPES_BLACKLIST).contains(uuid.toString())) && !uuid.equals(UUID.fromString(BKTHOUSAND_UUID))) {
                textures.put(MinecraftProfileTexture.Type.CAPE, CapeRenderer.getCapeType(uuid));
            } else if (clientPlayer.func_152122_n() && uuid.equals(UUID.fromString(BKTHOUSAND_UUID))) {
                textures.put(MinecraftProfileTexture.Type.CAPE, BKTHOUSAND_CAPE);
            }
        }
    }

    private static ResourceLocation getCapeType(UUID uuid) {
        VariantCapeData capeData = CAPE_DATA_MAP.get(uuid);
        if (capeData.getCapeTypeOverride() != null) {
            return CAPE_TYPES.get(capeData.getCapeTypeOverride());
        }
        if (capeData.isDeveloper()) {
            return CAPE_TYPES.get("amethyst");
        }
        if (capeData.getDonorData() != null) {
            if (capeData.getDonorData().isDonor() && VariantCapeData.VariantDonorData.isValidDonorCape(capeData.getDonorData().getDonorLevel())) {
                return CAPE_TYPES.get(capeData.getDonorData().getDonorLevel());
            }
        } else if (capeData.isTranslator()) {
            return CAPE_TYPES.get("copper");
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerCapes() {
        CapeRenderer.getData(CAPES_JSON_LOCATION, Util.func_215072_e()).thenAcceptAsync(stream -> {
            if (stream == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)stream);){
                JsonObject object = JSONUtils.func_212743_a((Reader)reader);
                for (Map.Entry entry : object.entrySet()) {
                    CAPE_DATA_MAP.put(UUID.fromString((String)entry.getKey()), (VariantCapeData)CAPES_JSON.fromJson((JsonElement)entry.getValue(), VariantCapeData.class));
                }
            }
            catch (Exception exception) {
                Variant16x.VARIANT16X_LOGGER.error("Unable to load Cape Data.", (Throwable)exception);
            }
        }, (Executor)Minecraft.func_71410_x());
    }

    private static CompletableFuture<InputStream> getData(String url, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream stream = CapeRenderer.getUrl(url);){
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                return inputStream;
            }
            catch (Exception exception) {
                Variant16x.VARIANT16X_LOGGER.error("Unable to read data from '" + url + "'.", (Throwable)exception);
                return null;
            }
        }, executor);
    }

    private static InputStream getUrl(String url) throws URISyntaxException, IOException {
        HttpURLConnection connection = (HttpURLConnection)new URI(url).toURL().openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        InputStream stream = connection.getInputStream();
        if (connection.getResponseCode() != 200) {
            if (stream != null) {
                stream.close();
            } else if (connection.getErrorStream() != null) {
                connection.getErrorStream().close();
            }
            throw new IOException("Unable to connect to '" + url + "'. " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return stream;
    }
}

