/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.placement.ConfiguredPlacement;

public class FeatureRegistry {
    public static ConfiguredFeature<?, ?> INFESTED_ANDESITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_ANDESITE);
    public static ConfiguredFeature<?, ?> INFESTED_DIORITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_DIORITE);
    public static ConfiguredFeature<?, ?> INFESTED_GRANITE_CONFIG = FeatureRegistry.registerInfested(BlockRegistry.INFESTED_GRANITE);
    public static ConfiguredFeature<?, ?> PAEONIA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.PAEONIA);
    public static ConfiguredFeature<?, ?> ROSE_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.ROSE);
    public static ConfiguredFeature<?, ?> SYRINGA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SYRINGA);
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SMALL_SUNFLOWER);
    public static ConfiguredFeature<HugeFungusConfig, ?> CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfig, ?> WARPED_FUNGUS_PLANTED_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfig, ?> CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG;
    public static ConfiguredFeature<HugeFungusConfig, ?> WARPED_FUNGUS_PLANTED_STAIRS_CONFIG;
    public static ConfiguredFeature<HugeFungusConfig, ?> CRIMSON_FUNGUS_PLANTED_VERTICAL_SLAB_CONFIG;
    public static ConfiguredFeature<HugeFungusConfig, ?> WARPED_FUNGUS_PLANTED_VERTICAL_SLAB_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_ANDESITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_DIORITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_GRANITE_BLOBS_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_PATCHES_CONFIG;

    public static void registerFeatures() {
        CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.CRIMSON_NYLIUM_SLAB, false);
        WARPED_FUNGUS_PLANTED_SLAB_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.WARPED_NYLIUM_SLAB, true);
        CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.CRIMSON_NYLIUM_STAIRS, false);
        WARPED_FUNGUS_PLANTED_STAIRS_CONFIG = FeatureRegistry.registerFungusPlanted(BlockRegistry.WARPED_NYLIUM_STAIRS, true);
        INFESTED_ANDESITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_ANDESITE_CONFIG, 2);
        INFESTED_DIORITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_DIORITE_CONFIG, 2);
        INFESTED_GRANITE_BLOBS_CONFIG = FeatureRegistry.registerBlob(INFESTED_GRANITE_CONFIG, 2);
        RARE_PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 1);
        PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 8);
        RARE_ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 1);
        ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 8);
        RARE_SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 1);
        SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 8);
        SMALL_SUNFLOWER_PATCHES_CONFIG = FeatureRegistry.registerPatch(SMALL_SUNFLOWER_CONFIG, 9);
        FeatureRegistry.register(CRIMSON_FUNGUS_PLANTED_SLAB_CONFIG, "variant16x", "crimson_fungus_planted_slab");
        FeatureRegistry.register(WARPED_FUNGUS_PLANTED_SLAB_CONFIG, "variant16x", "warped_fungus_planted_slab");
        FeatureRegistry.register(CRIMSON_FUNGUS_PLANTED_STAIRS_CONFIG, "variant16x", "crimson_fungus_planted_stairs");
        FeatureRegistry.register(WARPED_FUNGUS_PLANTED_STAIRS_CONFIG, "variant16x", "warped_fungus_planted_stairs");
        FeatureRegistry.register(INFESTED_ANDESITE_BLOBS_CONFIG, "variant16x", "infested_andesite_blobs");
        FeatureRegistry.register(INFESTED_DIORITE_BLOBS_CONFIG, "variant16x", "infested_diorite_blobs");
        FeatureRegistry.register(INFESTED_GRANITE_BLOBS_CONFIG, "variant16x", "infested_granite_blobs");
        FeatureRegistry.register(RARE_PAEONIA_PATCHES_CONFIG, "variant16x", "rare_paeonia_patches");
        FeatureRegistry.register(PAEONIA_PATCHES_CONFIG, "variant16x", "paeonia_patches");
        FeatureRegistry.register(RARE_ROSE_PATCHES_CONFIG, "variant16x", "rare_rose_patches");
        FeatureRegistry.register(ROSE_PATCHES_CONFIG, "variant16x", "rose_patches");
        FeatureRegistry.register(RARE_SYRINGA_PATCHES_CONFIG, "variant16x", "rare_syringa_patches");
        FeatureRegistry.register(SYRINGA_PATCHES_CONFIG, "variant16x", "syringa_patches");
        FeatureRegistry.register(SMALL_SUNFLOWER_PATCHES_CONFIG, "variant16x", "small_sunflower_patches");
    }

    public static <FC extends IFeatureConfig> ConfiguredFeature<?, ?> register(ConfiguredFeature<FC, ?> feature, String modId, String featureId) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(modId, featureId), feature);
    }

    private static ConfiguredFeature<HugeFungusConfig, ?> registerFungusPlanted(Block block, boolean isWarped) {
        if (isWarped) {
            return Feature.field_236281_L_.func_225566_b_((IFeatureConfig)new HugeFungusConfig(block.func_176223_P(), Blocks.field_235368_mh_.func_176223_P(), Blocks.field_235374_mn_.func_176223_P(), Blocks.field_235383_mw_.func_176223_P(), true));
        }
        return Feature.field_236281_L_.func_225566_b_((IFeatureConfig)new HugeFungusConfig(block.func_176223_P(), Blocks.field_235377_mq_.func_176223_P(), Blocks.field_189878_dg.func_176223_P(), Blocks.field_235383_mw_.func_176223_P(), true));
    }

    private static ConfiguredFeature<?, ?> registerInfested(Block block) {
        return Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, block.func_176223_P(), 7));
    }

    private static ConfiguredFeature<?, ?> registerPlant(Block block) {
        return Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
    }

    public static ConfiguredFeature<?, ?> registerBlob(ConfiguredFeature<?, ?> feature, int count) {
        return (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)feature.func_242733_d(64)).func_242728_a()).func_242731_b(count);
    }

    public static ConfiguredFeature<?, ?> registerPatch(ConfiguredFeature<?, ?> feature, int count) {
        return ((ConfiguredFeature)Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(() -> feature))).func_242730_a(FeatureSpread.func_242253_a((int)-3, (int)4))).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(count));
    }
}

