/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.FeatureRegistry;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="variant16x", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeRegistry {
    @SubscribeEvent
    public static void registerBiomes(BiomeLoadingEvent biomeEvent) {
        String biomeId = biomeEvent.getName().toString();
        BiomeGenerationSettingsBuilder biomeGeneration = biomeEvent.getGeneration();
        if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_MISCELLANEOUS)) {
            if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_INFESTED_STONES) && (biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185443_S)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185434_af)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_76783_v)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_76770_e)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_150580_W)))) {
                BiomeRegistry.registerInfestedAndesiteDioriteAndGranite((BiomeGenerationSettings.Builder)biomeGeneration);
            }
            if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_SMALL_FLOWERS)) {
                if (biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_150583_P)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_150582_Q)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_150585_R)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185430_ab)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_76767_f)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185448_Z)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185429_aa)) || biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_76785_t))) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa((BiomeGenerationSettings.Builder)biomeGeneration, false);
                }
                if (biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185444_T))) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa((BiomeGenerationSettings.Builder)biomeGeneration, true);
                }
                if (biomeId.equals(BiomeRegistry.getBiomeId((RegistryKey<Biome>)Biomes.field_185441_Q))) {
                    BiomeRegistry.registerSmallSunflower((BiomeGenerationSettings.Builder)biomeGeneration);
                }
            }
        }
    }

    public static void registerInfestedAndesiteDioriteAndGranite(BiomeGenerationSettings.Builder biomeGeneration) {
        BiomeRegistry.registerInfestedAndesite(biomeGeneration);
        BiomeRegistry.registerInfestedDiorite(biomeGeneration);
        BiomeRegistry.registerInfestedGranite(biomeGeneration);
    }

    public static void registerInfestedAndesite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_ANDESITE_BLOBS_CONFIG);
    }

    public static void registerInfestedDiorite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_DIORITE_BLOBS_CONFIG);
    }

    public static void registerInfestedGranite(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.INFESTED_GRANITE_BLOBS_CONFIG);
    }

    public static void registerPaeoniaRoseAndSyringa(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        BiomeRegistry.registerPaeonia(biomeGeneration, isCommon);
        BiomeRegistry.registerRose(biomeGeneration, isCommon);
        BiomeRegistry.registerSyringa(biomeGeneration, isCommon);
    }

    public static void registerPaeonia(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.PAEONIA_PATCHES_CONFIG);
        } else {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_PAEONIA_PATCHES_CONFIG);
        }
    }

    public static void registerRose(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.ROSE_PATCHES_CONFIG);
        } else {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_ROSE_PATCHES_CONFIG);
        }
    }

    public static void registerSyringa(BiomeGenerationSettings.Builder biomeGeneration, boolean isCommon) {
        if (isCommon) {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SYRINGA_PATCHES_CONFIG);
        } else {
            biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.RARE_SYRINGA_PATCHES_CONFIG);
        }
    }

    public static void registerSmallSunflower(BiomeGenerationSettings.Builder biomeGeneration) {
        biomeGeneration.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SMALL_SUNFLOWER_PATCHES_CONFIG);
    }

    public static String getBiomeId(RegistryKey<Biome> biome) {
        return biome.func_240901_a_().toString();
    }
}

