/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.variant16x.block.VariantFallingSlabBlock;
import net.blazekrew.variant16x.block.VariantFallingStairsBlock;
import net.blazekrew.variant16x.block.VariantFallingWallBlock;
import net.blazekrew.variant16x.block.addon.VariantFallingVerticalSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallingDustParticle.Factory.class})
public class ClientFallingDustParticleFactoryMixin {
    @Final
    @Shadow
    private IAnimatedSprite field_217526_a;

    @Inject(method={"createParticle(Lnet/minecraft/particles/BlockParticleData;Lnet/minecraft/client/world/ClientWorld;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void createParticleVariant(BlockParticleData particleData, ClientWorld world, double x, double y, double z, double speedX, double speedY, double speedZ, CallbackInfoReturnable<Particle> info) {
        BlockState state = particleData.func_197584_c();
        Block block = state.func_177230_c();
        if (block instanceof VariantFallingSlabBlock || block instanceof VariantFallingStairsBlock || block instanceof VariantFallingWallBlock || block instanceof VariantFallingVerticalSlabBlock) {
            BlockPos position = new BlockPos(x, y, z);
            int color = block instanceof VariantFallingSlabBlock ? ((VariantFallingSlabBlock)block).getDustColor(state, (IBlockReader)world, position) : (block instanceof VariantFallingStairsBlock ? ((VariantFallingStairsBlock)block).getDustColor(state, (IBlockReader)world, position) : (block instanceof VariantFallingWallBlock ? ((VariantFallingWallBlock)block).getDustColor(state, (IBlockReader)world, position) : ((VariantFallingVerticalSlabBlock)block).getDustColor(state, (IBlockReader)world, position)));
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            info.setReturnValue((Object)new FallingDustParticle(world, x, y, z, red, green, blue, this.field_217526_a));
        }
    }
}

