/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.dirtlogic16x.logic.IDirtLogicIsBlockLogic;
import net.blazekrew.dirtlogic16x.logic.IDirtLogicIsValidLogic;
import net.blazekrew.dirtlogic16x.registry.IDirtLogicTagRegistry;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.TagRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin
implements IDirtLogicIsValidLogic,
IDirtLogicIsBlockLogic {
    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=0)}, cancellable=true, remap=false)
    private void canSustainPlantCactus(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if (TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=2)}, cancellable=true, remap=false)
    private void canSustainPlantBush(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if (this.isValidType(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true, remap=false)
    private void canSustainPlantDesert(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if ((TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block) || BlockMixin.isTerracotta(block)) && !BlockMixin.isRedSand(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=9)}, cancellable=true, remap=false)
    private void canSustainPlantBeach(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        boolean hasWater = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockState = world.func_180495_p(position.func_177972_a(direction));
            FluidState fluidState = world.func_204610_c(position.func_177972_a(direction));
            if (blockState.func_177230_c() != Blocks.field_185778_de && !fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            hasWater = true;
            break;
        }
        if (TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block) && hasWater) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    private static boolean isRedSand(Block block) {
        return block == BlockRegistry.RED_SAND_SLAB || block == BlockRegistry.RED_SAND_STAIRS || block == BlockRegistry.RED_SAND_WALL || block == BlockRegistry.RED_SAND_VERTICAL_SLAB;
    }

    private static boolean isTerracotta(Block block) {
        return block == BlockRegistry.TERRACOTTA_SLAB || block == BlockRegistry.TERRACOTTA_STAIRS || block == BlockRegistry.TERRACOTTA_WALL || block == BlockRegistry.TERRACOTTA_VERTICAL_SLAB;
    }
}

