/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.blazekrew.variant16x.entity.VariantBoatEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BoatModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VariantBoatRenderer
extends EntityRenderer<VariantBoatEntity> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{new ResourceLocation("variant16x", "textures/entity/boat/crimson.png"), new ResourceLocation("variant16x", "textures/entity/boat/warped.png")};
    protected BoatModel model = new BoatModel();

    public VariantBoatRenderer(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.8f;
    }

    public void render(VariantBoatEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        float bubbleAngle;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.375, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float hurtTime = (float)entity.func_70268_h() - partialTicks;
        float damage = entity.func_70271_g() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)hurtTime) * hurtTime * damage / 10.0f * (float)entity.func_70267_i()));
        }
        if (!MathHelper.func_180185_a((float)(bubbleAngle = entity.func_203056_b(partialTicks)), (float)0.0f)) {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.func_203056_b(partialTicks), true));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        this.model.func_225597_a_((BoatEntity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        IVertexBuilder vertexBuilder = buffer.getBuffer(this.model.func_228282_a_(this.getTextureLocation(entity)));
        this.model.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.func_204231_K()) {
            IVertexBuilder newVertexBuilder = buffer.getBuffer(RenderType.func_228651_i_());
            this.model.func_228245_c_().func_228308_a_(matrixStack, newVertexBuilder, packedLight, OverlayTexture.field_229196_a_);
        }
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(VariantBoatEntity entity) {
        return BOAT_TEXTURES[entity.getBoatType2().ordinal()];
    }
}

