/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.entity;

import net.blazekrew.variant16x.registry.EntityRegistry;
import net.blazekrew.variant16x.registry.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class VariantBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(VariantBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public VariantBoatEntity(EntityType<? extends BoatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public VariantBoatEntity(World world, double x, double y, double z) {
        this(EntityRegistry.BOAT, world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public VariantBoatEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super(EntityRegistry.BOAT, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)VariantBoatType.CRIMSON.ordinal());
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getBoatType2().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setType(VariantBoatType.byName(compound.func_74779_i("Type")));
        }
    }

    public Item func_184455_j() {
        if (this.getBoatType2() == VariantBoatType.WARPED) {
            return ItemRegistry.WARPED_BOAT;
        }
        return ItemRegistry.CRIMSON_BOAT;
    }

    public void setType(VariantBoatType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public VariantBoatType getBoatType2() {
        return VariantBoatType.byId((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab() && !this.func_190530_aW() && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.func_199703_a((IItemProvider)this.func_184455_j());
            }
        }
    }

    protected void func_184231_a(double y, boolean onGround, BlockState state, BlockPos position) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGround) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)this.getBoatType2().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public static enum VariantBoatType {
        CRIMSON(Blocks.field_235344_mC_, "crimson"),
        WARPED(Blocks.field_235345_mD_, "warped");

        private final String name;
        private final Block block;

        private VariantBoatType(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static VariantBoatType byId(int id) {
            VariantBoatType[] boat$type = VariantBoatType.values();
            if (id < 0 || id >= boat$type.length) {
                id = 0;
            }
            return boat$type[id];
        }

        public static VariantBoatType byName(String name) {
            VariantBoatType[] boat$type;
            for (VariantBoatType type : boat$type = VariantBoatType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return boat$type[0];
        }
    }
}

