/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.data;

public final class VariantCapeData {
    private final VariantDonorData donorData;
    private final boolean isTranslator;
    private final boolean isDeveloper;
    private final String capeTypeOverride;

    public VariantCapeData(String username, VariantDonorData donorData, boolean isTranslator, boolean isDeveloper, String capeTypeOverride) {
        this.donorData = donorData;
        this.isTranslator = isTranslator;
        this.isDeveloper = isDeveloper;
        this.capeTypeOverride = VariantCapeData.setCapeTypeOverride(capeTypeOverride);
    }

    public VariantDonorData getDonorData() {
        return this.donorData;
    }

    public boolean isTranslator() {
        return this.isTranslator;
    }

    public boolean isDeveloper() {
        return this.isDeveloper;
    }

    public String getCapeTypeOverride() {
        return this.capeTypeOverride;
    }

    private static String setCapeTypeOverride(String capeType) {
        String capeTypeName = null;
        if (VariantCapeData.isValidCape(capeType)) {
            capeTypeName = capeType;
        }
        return capeTypeName;
    }

    private static boolean isValidCape(String capeType) {
        return capeType.equals("creator") || capeType.equals("amethyst") || capeType.equals("emerald") || capeType.equals("diamond") || capeType.equals("gold") || capeType.equals("copper");
    }

    public static final class VariantDonorData {
        private final boolean isDonor;
        private final String donorLevel;

        public VariantDonorData(boolean isDonor, String donorLevel) {
            this.isDonor = isDonor;
            this.donorLevel = VariantDonorData.setDonorLevel(donorLevel);
        }

        public boolean isDonor() {
            return this.isDonor;
        }

        public String getDonorLevel() {
            return this.donorLevel;
        }

        private static String setDonorLevel(String donorLevel) {
            String donorLevelName = null;
            if (VariantDonorData.isValidDonorCape(donorLevel)) {
                donorLevelName = donorLevel;
            }
            return donorLevelName;
        }

        public static boolean isValidDonorCape(String capeType) {
            return capeType.equals("emerald") || capeType.equals("diamond") || capeType.equals("gold");
        }
    }
}

