/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.block;

import net.blazekrew.variant16x.block.VariantFallingSlabBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VariantConcretePowderSlabBlock
extends VariantFallingSlabBlock {
    private final BlockState concrete;

    public VariantConcretePowderSlabBlock(Block concreteBlock, AbstractBlock.Properties properties) {
        super(properties);
        this.concrete = concreteBlock.func_176223_P();
    }

    @Override
    public void onLand(World world, BlockPos position, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingEntity) {
        if (VariantConcretePowderSlabBlock.shouldSolidify((IBlockReader)world, position, hitState)) {
            world.func_180501_a(position, (BlockState)((BlockState)this.concrete.func_206870_a((Property)field_196505_a, fallingState.func_177229_b((Property)field_196505_a))).func_206870_a((Property)field_204512_b, fallingState.func_177229_b((Property)field_204512_b)), 3);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state;
        BlockPos position;
        World world = context.func_195991_k();
        if (VariantConcretePowderSlabBlock.shouldSolidify((IBlockReader)world, position = context.func_195995_a(), state = world.func_180495_p(position))) {
            if (state.func_177230_c() == this.concrete.func_177230_c()) {
                return (BlockState)((BlockState)state.func_206870_a((Property)field_196505_a, (Comparable)SlabType.DOUBLE)).func_206870_a((Property)field_204512_b, (Comparable)Boolean.valueOf(false));
            }
            FluidState fluidState = world.func_204610_c(position);
            BlockState blockState = (BlockState)((BlockState)this.concrete.func_206870_a((Property)field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)field_204512_b, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
            Direction direction = context.func_196000_l();
            if (direction != Direction.DOWN && (direction == Direction.UP || context.func_221532_j().field_72448_b - (double)position.func_177956_o() <= 0.5)) {
                return blockState;
            }
            return (BlockState)blockState.func_206870_a((Property)field_196505_a, (Comparable)SlabType.TOP);
        }
        return super.func_196258_a(context);
    }

    private static boolean shouldSolidify(IBlockReader world, BlockPos position, BlockState state) {
        return VariantConcretePowderSlabBlock.canSolidify(state) || VariantConcretePowderSlabBlock.touchesLiquid(world, position);
    }

    private static boolean touchesLiquid(IBlockReader world, BlockPos position) {
        boolean flag = false;
        BlockPos.Mutable position$mutable = position.func_239590_i_();
        for (Direction direction : Direction.values()) {
            BlockState state = world.func_180495_p((BlockPos)position$mutable);
            if (direction == Direction.DOWN && !VariantConcretePowderSlabBlock.canSolidify(state)) continue;
            position$mutable.func_239622_a_((Vector3i)position, direction);
            state = world.func_180495_p((BlockPos)position$mutable);
            if (!VariantConcretePowderSlabBlock.canSolidify(state) || state.func_224755_d(world, position, direction.func_176734_d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos position, BlockPos facingPosition) {
        if (VariantConcretePowderSlabBlock.touchesLiquid((IBlockReader)world, position)) {
            return (BlockState)((BlockState)this.concrete.func_206870_a((Property)field_196505_a, state.func_177229_b((Property)field_196505_a))).func_206870_a((Property)field_204512_b, state.func_177229_b((Property)field_204512_b));
        }
        return super.func_196271_a(state, facing, facingState, world, position, facingPosition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, IBlockReader world, BlockPos position) {
        return state.func_185909_g((IBlockReader)world, (BlockPos)position).field_76291_p;
    }
}

