/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x;

import net.blazekrew.variant16x.registry.CompostableRegistry;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.blazekrew.variant16x.registry.DispenseBehaviorRegistry;
import net.blazekrew.variant16x.registry.FeatureRegistry;
import net.blazekrew.variant16x.registry.FlammableRegistry;
import net.blazekrew.variant16x.registry.StrippableRegistry;
import net.blazekrew.variant16x.registry.renderer.BlockRenderer;
import net.blazekrew.variant16x.registry.renderer.CapeRenderer;
import net.blazekrew.variant16x.registry.renderer.EntityRenderer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="variant16x")
public class Variant16x {
    public static final String VARIANT16X_ID = "variant16x";
    private static final String VARIANT16X_CONFIG = "variant16x/variant16x-common.toml";
    private static final String VARIANT16X_SERVER_CONFIG = "variant16x-server.toml";
    public static final Logger VARIANT16X_LOGGER = LogManager.getLogger((String)"Variant16x");

    public Variant16x() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigRegistry.COMMON, VARIANT16X_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigRegistry.SERVER, VARIANT16X_SERVER_CONFIG);
        ConfigRegistry.registerConfigs(ConfigRegistry.COMMON, VARIANT16X_CONFIG);
        ConfigRegistry.registerConfigIdsAndValues(ConfigRegistry.VARIANT16X_CONFIG_MAP);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent commonEvent) {
        commonEvent.enqueueWork(() -> {
            CompostableRegistry.registerCompostables();
            DispenseBehaviorRegistry.registerDispenseBehaviors();
            FeatureRegistry.registerFeatures();
            FlammableRegistry.registerFlammables();
            StrippableRegistry.registerStrippables();
        });
    }

    private void onClientSetup(FMLClientSetupEvent clientEvent) {
        clientEvent.enqueueWork(() -> BlockRenderer.renderBlocks());
        EntityRenderer.renderEntities();
        CapeRenderer.registerCapes();
    }
}

