/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.minecraft.block.Block;

public class StrippableRegistry {
    public static Map<Block, Block> SLAB_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> STAIRS_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> FENCE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> FENCE_GATE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> PRESSURE_PLATE_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> BUTTON_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();
    public static Map<Block, Block> VERTICAL_SLAB_BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().build();

    public static void registerStrippables() {
        StrippableRegistry.registerSlab(BlockRegistry.ACACIA_WOOD_SLAB, BlockRegistry.STRIPPED_ACACIA_WOOD_SLAB);
        StrippableRegistry.registerSlab(BlockRegistry.BIRCH_WOOD_SLAB, BlockRegistry.STRIPPED_BIRCH_WOOD_SLAB);
        StrippableRegistry.registerSlab(BlockRegistry.DARK_OAK_WOOD_SLAB, BlockRegistry.STRIPPED_DARK_OAK_WOOD_SLAB);
        StrippableRegistry.registerSlab(BlockRegistry.JUNGLE_WOOD_SLAB, BlockRegistry.STRIPPED_JUNGLE_WOOD_SLAB);
        StrippableRegistry.registerSlab(BlockRegistry.OAK_WOOD_SLAB, BlockRegistry.STRIPPED_OAK_WOOD_SLAB);
        StrippableRegistry.registerSlab(BlockRegistry.SPRUCE_WOOD_SLAB, BlockRegistry.STRIPPED_SPRUCE_WOOD_SLAB);
        StrippableRegistry.registerStairs(BlockRegistry.ACACIA_WOOD_STAIRS, BlockRegistry.STRIPPED_ACACIA_WOOD_STAIRS);
        StrippableRegistry.registerStairs(BlockRegistry.BIRCH_WOOD_STAIRS, BlockRegistry.STRIPPED_BIRCH_WOOD_STAIRS);
        StrippableRegistry.registerStairs(BlockRegistry.DARK_OAK_WOOD_STAIRS, BlockRegistry.STRIPPED_DARK_OAK_WOOD_STAIRS);
        StrippableRegistry.registerStairs(BlockRegistry.JUNGLE_WOOD_STAIRS, BlockRegistry.STRIPPED_JUNGLE_WOOD_STAIRS);
        StrippableRegistry.registerStairs(BlockRegistry.OAK_WOOD_STAIRS, BlockRegistry.STRIPPED_OAK_WOOD_STAIRS);
        StrippableRegistry.registerStairs(BlockRegistry.SPRUCE_WOOD_STAIRS, BlockRegistry.STRIPPED_SPRUCE_WOOD_STAIRS);
        StrippableRegistry.registerFence(BlockRegistry.ACACIA_WOOD_FENCE, BlockRegistry.STRIPPED_ACACIA_WOOD_FENCE);
        StrippableRegistry.registerFence(BlockRegistry.BIRCH_WOOD_FENCE, BlockRegistry.STRIPPED_BIRCH_WOOD_FENCE);
        StrippableRegistry.registerFence(BlockRegistry.DARK_OAK_WOOD_FENCE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_FENCE);
        StrippableRegistry.registerFence(BlockRegistry.JUNGLE_WOOD_FENCE, BlockRegistry.STRIPPED_JUNGLE_WOOD_FENCE);
        StrippableRegistry.registerFence(BlockRegistry.OAK_WOOD_FENCE, BlockRegistry.STRIPPED_OAK_WOOD_FENCE);
        StrippableRegistry.registerFence(BlockRegistry.SPRUCE_WOOD_FENCE, BlockRegistry.STRIPPED_SPRUCE_WOOD_FENCE);
        StrippableRegistry.registerFenceGate(BlockRegistry.ACACIA_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_ACACIA_WOOD_FENCE_GATE);
        StrippableRegistry.registerFenceGate(BlockRegistry.BIRCH_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_BIRCH_WOOD_FENCE_GATE);
        StrippableRegistry.registerFenceGate(BlockRegistry.DARK_OAK_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_FENCE_GATE);
        StrippableRegistry.registerFenceGate(BlockRegistry.JUNGLE_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_JUNGLE_WOOD_FENCE_GATE);
        StrippableRegistry.registerFenceGate(BlockRegistry.OAK_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_OAK_WOOD_FENCE_GATE);
        StrippableRegistry.registerFenceGate(BlockRegistry.SPRUCE_WOOD_FENCE_GATE, BlockRegistry.STRIPPED_SPRUCE_WOOD_FENCE_GATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.ACACIA_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_ACACIA_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.BIRCH_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_BIRCH_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.DARK_OAK_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_DARK_OAK_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.JUNGLE_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_JUNGLE_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.OAK_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_OAK_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerPressurePlate(BlockRegistry.SPRUCE_WOOD_PRESSURE_PLATE, BlockRegistry.STRIPPED_SPRUCE_WOOD_PRESSURE_PLATE);
        StrippableRegistry.registerButton(BlockRegistry.ACACIA_WOOD_BUTTON, BlockRegistry.STRIPPED_ACACIA_WOOD_BUTTON);
        StrippableRegistry.registerButton(BlockRegistry.BIRCH_WOOD_BUTTON, BlockRegistry.STRIPPED_BIRCH_WOOD_BUTTON);
        StrippableRegistry.registerButton(BlockRegistry.DARK_OAK_WOOD_BUTTON, BlockRegistry.STRIPPED_DARK_OAK_WOOD_BUTTON);
        StrippableRegistry.registerButton(BlockRegistry.JUNGLE_WOOD_BUTTON, BlockRegistry.STRIPPED_JUNGLE_WOOD_BUTTON);
        StrippableRegistry.registerButton(BlockRegistry.OAK_WOOD_BUTTON, BlockRegistry.STRIPPED_OAK_WOOD_BUTTON);
        StrippableRegistry.registerButton(BlockRegistry.SPRUCE_WOOD_BUTTON, BlockRegistry.STRIPPED_SPRUCE_WOOD_BUTTON);
    }

    public static void registerSlab(Block block, Block strippedBlock) {
        SLAB_BLOCK_STRIPPING_MAP = Maps.newHashMap(SLAB_BLOCK_STRIPPING_MAP);
        SLAB_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerStairs(Block block, Block strippedBlock) {
        STAIRS_BLOCK_STRIPPING_MAP = Maps.newHashMap(STAIRS_BLOCK_STRIPPING_MAP);
        STAIRS_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerFence(Block block, Block strippedBlock) {
        FENCE_BLOCK_STRIPPING_MAP = Maps.newHashMap(FENCE_BLOCK_STRIPPING_MAP);
        FENCE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerFenceGate(Block block, Block strippedBlock) {
        FENCE_GATE_BLOCK_STRIPPING_MAP = Maps.newHashMap(FENCE_GATE_BLOCK_STRIPPING_MAP);
        FENCE_GATE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerPressurePlate(Block block, Block strippedBlock) {
        PRESSURE_PLATE_BLOCK_STRIPPING_MAP = Maps.newHashMap(PRESSURE_PLATE_BLOCK_STRIPPING_MAP);
        PRESSURE_PLATE_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }

    public static void registerButton(Block block, Block strippedBlock) {
        BUTTON_BLOCK_STRIPPING_MAP = Maps.newHashMap(BUTTON_BLOCK_STRIPPING_MAP);
        BUTTON_BLOCK_STRIPPING_MAP.put(block, strippedBlock);
    }
}

