/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.variant16x.block.VariantFallingSlabBlock;
import net.blazekrew.variant16x.block.VariantFallingStairsBlock;
import net.blazekrew.variant16x.block.VariantFallingWallBlock;
import net.blazekrew.variant16x.block.addon.VariantFallingVerticalSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.Particle;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallingDustParticle.Factory.class})
public class ClientFallingDustParticleFactoryMixin {
    @Shadow
    private IAnimatedSprite field_217526_a;

    @Inject(method={"makeParticle"}, at={@At(value="HEAD")}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void makeParticleVariant(BlockParticleData data, World world, double x, double y, double z, double speedX, double speedY, double speedZ, CallbackInfoReturnable<Particle> info) {
        BlockState state = data.func_197584_c();
        Block block = state.func_177230_c();
        if (block instanceof VariantFallingSlabBlock || block instanceof VariantFallingStairsBlock || block instanceof VariantFallingWallBlock || block instanceof VariantFallingVerticalSlabBlock) {
            if (!state.func_196958_f() && state.func_185901_i() == BlockRenderType.INVISIBLE) {
                info.setReturnValue(null);
            } else {
                int color = Minecraft.func_71410_x().func_184125_al().func_189991_a(state, world, new BlockPos(x, y, z));
                if (state.func_177230_c() instanceof VariantFallingSlabBlock) {
                    color = ((VariantFallingSlabBlock)state.func_177230_c()).getDustColor(state);
                }
                if (state.func_177230_c() instanceof VariantFallingStairsBlock) {
                    color = ((VariantFallingStairsBlock)state.func_177230_c()).getDustColor(state);
                }
                if (state.func_177230_c() instanceof VariantFallingWallBlock) {
                    color = ((VariantFallingWallBlock)state.func_177230_c()).getDustColor(state);
                }
                if (state.func_177230_c() instanceof VariantFallingVerticalSlabBlock) {
                    color = ((VariantFallingVerticalSlabBlock)state.func_177230_c()).getDustColor(state);
                }
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                info.setReturnValue((Object)new FallingDustParticle(world, x, y, z, red, green, blue, this.field_217526_a));
            }
        }
    }
}

